/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import net.petemc.undeadnights.util.Helpers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements UndeadNightsExtendedPlayer {
    @Unique
    private boolean hasHordeLureEffect = false;
    @Unique
    private boolean isInCave = false;
    @Unique
    private boolean isInCaveStageOne = false;
    @Unique
    private boolean previousIsInCaveStageOne = false;
    @Unique
    private boolean isInCaveStageTwo = false;
    @Unique
    private boolean previousIsInCaveStageTwo = false;
    @Unique
    private int coolDown = 100;
    @Unique
    private int delay = 3;

    @Override
    public void undeadnights_setHordeLureEffect(boolean hordeLureValue) {
        this.hasHordeLureEffect = hordeLureValue;
    }

    @Override
    public boolean undeadnights_hasHordeLureEffect() {
        return this.hasHordeLureEffect;
    }

    @Override
    public void undeadnights_setIsInCave(boolean isInCaveValue) {
        this.isInCave = isInCaveValue;
    }

    @Override
    public boolean undeadnights_isInCave() {
        return this.isInCave;
    }

    @Override
    public boolean undeadnights_isInCaveDelayed() {
        return this.isInCaveStageOne;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;updatePlayerPose()V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.m_9236_().m_5776_()) {
            if (this.coolDown > 0) {
                --this.coolDown;
            } else {
                this.coolDown = 100;
                this.isInCaveStageOne = Helpers.caveCheckStageOne(player.m_9236_(), player.m_20183_());
                if (this.isInCaveStageOne) {
                    if (this.delay > 0) {
                        --this.delay;
                    } else {
                        this.delay = 3;
                        this.isInCaveStageTwo = Helpers.caveCheckStageTwo(player.m_9236_(), player.m_20183_());
                        if (this.isInCaveStageTwo) {
                            this.undeadnights_setIsInCave(true);
                        }
                    }
                } else {
                    this.isInCaveStageTwo = false;
                    this.previousIsInCaveStageTwo = false;
                    this.undeadnights_setIsInCave(false);
                    this.delay = 3;
                }
                if (this.previousIsInCaveStageOne != this.isInCaveStageOne) {
                    this.previousIsInCaveStageOne = this.isInCaveStageOne;
                    if (this.isInCaveStageOne) {
                        // empty if block
                    }
                }
                if (this.isInCaveStageTwo != this.previousIsInCaveStageTwo) {
                    this.previousIsInCaveStageTwo = this.isInCaveStageTwo;
                }
            }
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToReadNbt(CompoundTag nbt, CallbackInfo ci) {
        this.isInCave = nbt.m_128471_("undeadnights_is_player_in_cave");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToWriteNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128379_("undeadnights_is_player_in_cave", this.isInCave);
    }
}

