/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.enchants_and_expeditions;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.legacy.enchants_and_expeditions.config.EaEConfig;
import net.legacy.enchants_and_expeditions.enchantment.EaEEnchantmentEffects;
import net.legacy.enchants_and_expeditions.network.EnchantingAttributes;
import net.legacy.enchants_and_expeditions.registry.EaEBlocks;
import net.legacy.enchants_and_expeditions.registry.EaECreativeInventorySorting;
import net.legacy.enchants_and_expeditions.registry.EaEDataComponents;
import net.legacy.enchants_and_expeditions.registry.EaEEnchantments;
import net.legacy.enchants_and_expeditions.registry.EaEItems;
import net.legacy.enchants_and_expeditions.registry.EaELootTables;
import net.legacy.enchants_and_expeditions.sound.EaEBlockSounds;
import net.legacy.enchants_and_expeditions.sound.EaESounds;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.slf4j.Logger;

public class EnchantsAndExpeditions
implements ModInitializer {
    public static final String MOD_ID = "enchants_and_expeditions";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean debug = false;
    public static boolean isLegaciesAndLegendsLoaded = false;
    public static boolean isProgressionRebornLoaded = false;
    public static boolean isTrailierTalesLoaded = false;
    public static boolean isEnderscapeLoaded = false;

    public void onInitialize() {
        PayloadTypeRegistry.playC2S().register(EnchantingAttributes.Request.ID, EnchantingAttributes.Request.CODEC);
        PayloadTypeRegistry.playS2C().register(EnchantingAttributes.Attributes.ID, EnchantingAttributes.Attributes.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(EnchantingAttributes.Request.ID, (payload, context) -> context.server().execute(() -> {
            String who;
            class_3222 player = context.player();
            String string = who = player != null ? player.method_7334().getName() : "<null player>";
            if (debug) {
                LOGGER.info("[EaE] C2S Request received from {}", (Object)who);
            }
            if (player == null) {
                if (debug) {
                    LOGGER.warn("[EaE] Aborting: player is null");
                }
                return;
            }
            class_1703 patt0$temp = player.field_7512;
            if (!(patt0$temp instanceof class_1718)) {
                if (debug) {
                    LOGGER.warn("[EaE] Aborting: player {} is not in an EnchantmentMenu (got {})", (Object)who, (Object)(player.field_7512 != null ? player.field_7512.getClass().getName() : "<null>"));
                }
                return;
            }
            class_1718 menu = (class_1718)patt0$temp;
            if (!(menu instanceof EnchantingAttributes)) {
                if (debug) {
                    LOGGER.warn("[EaE] Aborting: EnchantmentMenu does not implement EnchantingAttributes duck");
                }
                return;
            }
            EnchantingAttributes duck = (EnchantingAttributes)menu;
            EnchantingAttributes.Attributes a = duck.calculateAttributes();
            if (debug) {
                LOGGER.info("[EaE] Computed attributes for {} -> {}", (Object)who, (Object)a);
            }
            ServerPlayNetworking.send((class_3222)player, (class_8710)a);
            if (debug) {
                LOGGER.info("[EaE] S2C Attributes sent to {}: {}", (Object)who, (Object)a);
            }
        }));
        Optional modContainer = FabricLoader.getInstance().getModContainer(MOD_ID);
        EaEBlocks.init();
        EaEItems.init();
        EaECreativeInventorySorting.init();
        EaESounds.init();
        EaEBlockSounds.init();
        EaELootTables.init();
        EaEEnchantments.init();
        EaEDataComponents.init();
        EaEEnchantmentEffects.register();
        EaEConfig.initClient();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"vanilla_tag_replacements"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.enchants_and_expeditions.vanilla_tag_replacements"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        if (EaEConfig.get.integrations.item_tooltips_overrides) {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"item_tooltips_overrides"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.enchants_and_expeditions.item_tooltips_overrides"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (FabricLoader.getInstance().isModLoaded("legacies_and_legends") && EaEConfig.get.integrations.legacies_and_legends) {
            isLegaciesAndLegendsLoaded = true;
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"legacies_and_legends_integration"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.enchants_and_expeditions.legacies_and_legends_integration"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (FabricLoader.getInstance().isModLoaded("progression_reborn")) {
            isProgressionRebornLoaded = true;
        }
        if (FabricLoader.getInstance().isModLoaded("trailiertales") && EaEConfig.get.integrations.trailier_tales) {
            isTrailierTalesLoaded = true;
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"trailier_tales_integration"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.enchants_and_expeditions.trailier_tales_integration"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
        if (FabricLoader.getInstance().isModLoaded("enderscape") && EaEConfig.get.integrations.enderscape) {
            isEnderscapeLoaded = true;
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"enderscape_integration"), (ModContainer)((ModContainer)modContainer.get()), (class_2561)class_2561.method_43471((String)"pack.enchants_and_expeditions.enderscape_integration"), (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
        }
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

