/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.enchants_and_expeditions.config;

import java.nio.file.Path;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Config(name="enchants_and_expeditions")
public class EaEConfig
implements ConfigData {
    public static EaEConfig get;
    @ConfigEntry.Gui.CollapsibleObject
    public GeneralConfig general = new GeneralConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public MiscConfig misc = new MiscConfig();
    @ConfigEntry.Gui.CollapsibleObject
    public IntegrationConfig integrations = new IntegrationConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public Notice disable_enchantments = Notice.INFO;

    @Contract(pure=true)
    @NotNull
    public static Path configPath(boolean json5) {
        return Path.of("./config/enchants_and_expeditions." + (json5 ? "json5" : "json"), new String[0]);
    }

    public static void initClient() {
        AutoConfig.register(EaEConfig.class, JanksonConfigSerializer::new);
        get = (EaEConfig)AutoConfig.getConfigHolder(EaEConfig.class).getConfig();
    }

    public static class GeneralConfig {
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public int enchantment_limit = 3;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean repeat_table_enchanting = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean experience_rebalance = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(max=1L)
        public double anvil_break_chance = 0.12;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean craftable_experience_bottles = true;
    }

    public static class MiscConfig {
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean ordered_enchantment_tooltips = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean enchant_function_fallback = true;
        @ConfigEntry.Category(value="config")
        @ConfigEntry.Gui.Tooltip
        public boolean loot_table_injects = true;
    }

    public static class IntegrationConfig {
        @ConfigEntry.Category(value="config")
        public boolean item_tooltips_overrides = true;
        @ConfigEntry.Category(value="config")
        public boolean legacies_and_legends = true;
        @ConfigEntry.Category(value="config")
        public boolean trailier_tales = true;
        @ConfigEntry.Category(value="config")
        public boolean remnants = true;
        @ConfigEntry.Category(value="config")
        public boolean enderscape = true;
    }

    public static enum Notice {
        INFO;

    }
}

