/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.enchants_and_expeditions.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Random;
import net.legacy.enchants_and_expeditions.lib.EnchantingHelper;
import net.legacy.enchants_and_expeditions.registry.EaEEnchantments;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    class_1282 damageSource;
    @Unique
    int secondProgress;

    @Shadow
    public abstract void method_36549();

    @Shadow
    public abstract class_1799 method_6118(class_1304 var1);

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    @Shadow
    @Nullable
    public abstract class_1542 method_7329(class_1799 var1, boolean var2, boolean var3);

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")})
    private void getDamageSource(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.damageSource = damageSource;
    }

    @Inject(method={"hurtServer"}, at={@At(value="TAIL")})
    private void infernoBlessingExtendFire(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 attacker;
        class_1799 attackerStack;
        class_1309 entity = (class_1309)class_1309.class.cast(this);
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1309 && EnchantingHelper.hasEnchantment(attackerStack = (attacker = (class_1309)class_12972).method_5998(class_1268.field_5808), EaEEnchantments.INFERNO_BLESSING) && entity.method_5809()) {
            int setFireTicks = entity.method_20802() + 50;
            if (setFireTicks > 200) {
                setFireTicks = 200;
            }
            entity.method_20803(setFireTicks);
        }
    }

    @ModifyVariable(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float infernoBlessingDamage(float value) {
        class_1309 attacker;
        class_1799 attackerStack;
        class_1297 class_12972 = this.damageSource.method_5529();
        if (class_12972 instanceof class_1309 && EnchantingHelper.hasEnchantment(attackerStack = (attacker = (class_1309)class_12972).method_5998(class_1268.field_5808), EaEEnchantments.INFERNO_BLESSING)) {
            value += 1.0f;
        }
        return value;
    }

    @Inject(method={"hurtServer"}, at={@At(value="TAIL")})
    private void displacementCurse(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)class_1309.class.cast(this);
        class_1799 stack = entity.method_6118(class_1304.field_6174);
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (EnchantingHelper.hasEnchantment(stack, EaEEnchantments.DISPLACEMENT_CURSE)) {
                for (class_1293 instance : entity.method_6088().values()) {
                    if (!entity.method_6059(instance.method_5579())) {
                        return;
                    }
                    class_6880 effect = instance.method_5579();
                    int duration = entity.method_6112(effect).method_5584();
                    entity.method_6016(effect);
                    if (!attacker.method_6059(effect)) {
                        attacker.method_6092(new class_1293(effect, duration / 2));
                    }
                    entity.method_6092(new class_1293(effect, duration / 2));
                }
            }
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="TAIL")})
    private void frostbite(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 attacked = (class_1309)class_1309.class.cast(this);
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            class_1799 attackedChestplate = attacked.method_6118(class_1304.field_6174);
            if (EnchantingHelper.hasEnchantment(attackedChestplate, EaEEnchantments.FROSTBITE) && attacked.method_6032() > attacked.method_6063() - 1.0f) {
                int duration = 200;
                if (attacker.method_32312() < duration) {
                    attacker.method_32317(duration);
                }
                level.method_65096((class_2394)class_2398.field_28013, attacker.method_23317(), attacker.method_23319(), attacker.method_23321(), 10, 0.0, -1.0, 0.0, 0.5);
            }
        }
    }

    @ModifyVariable(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float entropy(float value) {
        class_1309 attacker;
        class_1799 attackerStack;
        class_1297 class_12972 = this.damageSource.method_5529();
        if (class_12972 instanceof class_1309 && EnchantingHelper.hasEnchantment(attackerStack = (attacker = (class_1309)class_12972).method_5998(class_1268.field_5808), EaEEnchantments.ENTROPY)) {
            int entropy = EnchantingHelper.getLevel(attackerStack, EaEEnchantments.ENTROPY);
            value += (float)new Random().nextInt(-1, 3 + entropy);
        }
        return value;
    }

    @ModifyVariable(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float vengeanceBlessing(float value) {
        class_1309 attacker;
        class_1799 attackerStack;
        class_1297 class_12972 = this.damageSource.method_5529();
        if (class_12972 instanceof class_1309 && EnchantingHelper.hasEnchantment(attackerStack = (attacker = (class_1309)class_12972).method_5998(class_1268.field_5808), EaEEnchantments.VENGEANCE_BLESSING) && attacker.method_6032() < 7.0f) {
            float amount = -attacker.method_6032() / 2.0f + 6.0f;
            value += amount;
        }
        return value;
    }

    @Inject(method={"getJumpPower()F"}, at={@At(value="TAIL")}, cancellable=true)
    private void leaping(CallbackInfoReturnable<Float> cir) {
        class_1309 livingEntity = (class_1309)class_1309.class.cast(this);
        if (!(livingEntity instanceof class_1496)) {
            return;
        }
        class_1496 horse = (class_1496)livingEntity;
        class_1799 stack = horse.method_56676();
        if (EnchantingHelper.hasEnchantment(stack, EaEEnchantments.LEAPING)) {
            int level = EnchantingHelper.getLevel(stack, EaEEnchantments.LEAPING);
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * (1.0f + (float)level * 0.1f)));
        }
    }

    @ModifyVariable(method={"hurtServer(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), index=3, argsOnly=true)
    private float ferocity(float value) {
        class_1493 wolf;
        class_1799 attackerStack;
        class_1297 class_12972 = this.damageSource.method_5529();
        if (class_12972 instanceof class_1493 && EnchantingHelper.hasEnchantment(attackerStack = (wolf = (class_1493)class_12972).method_56676(), EaEEnchantments.FEROCITY)) {
            int ferocity = EnchantingHelper.getLevel(attackerStack, EaEEnchantments.FEROCITY);
            value += (float)ferocity;
        }
        return value;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void ticksToSeconds(CallbackInfo ci) {
        if (this.secondProgress < 20) {
            ++this.secondProgress;
        } else {
            this.second();
            this.secondProgress = 0;
        }
    }

    @Unique
    private void second() {
        this.temperingBlessing();
        this.fluidityBlessing();
    }

    @Unique
    private void temperingBlessing() {
        class_1297 entity = (class_1297)class_1297.class.cast(this);
        if (entity.method_20802() <= 0) {
            return;
        }
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack;
            if (!slot.method_46643() || !EnchantingHelper.hasEnchantment(stack = this.method_6118(slot), EaEEnchantments.TEMPERING_BLESSING) || stack.method_7919() < 1) continue;
            stack.method_7974(stack.method_7919() - 1);
            if (stack.method_7919() >= 0) continue;
            stack.method_7974(0);
        }
    }

    @Unique
    private void fluidityBlessing() {
        class_1297 entity = (class_1297)class_1297.class.cast(this);
        if (!entity.method_5799()) {
            return;
        }
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack;
            if (!slot.method_46643() || !EnchantingHelper.hasEnchantment(stack = this.method_6118(slot), EaEEnchantments.FLUIDITY_BLESSING) || !(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            livingEntity.method_6025(0.5f);
        }
    }

    @Inject(method={"getSecondsToDisableBlocking"}, at={@At(value="TAIL")}, cancellable=true)
    private void cleaving(CallbackInfoReturnable<Float> cir) {
        float disableTime = ((Float)cir.getReturnValue()).floatValue();
        if (disableTime <= 0.0f) {
            return;
        }
        class_1799 stack = this.method_59958();
        if (EnchantingHelper.hasEnchantment(stack, EaEEnchantments.CLEAVING)) {
            cir.setReturnValue((Object)Float.valueOf(disableTime += (float)EnchantingHelper.getLevel(stack, EaEEnchantments.CLEAVING)));
        }
    }

    @WrapOperation(method={"travelInAir"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;getFriction()F")})
    private float slidingCurse(class_2248 block, Operation<Float> original) {
        class_1799 stack = this.method_6118(class_1304.field_6166);
        if (EnchantingHelper.hasEnchantment(stack, EaEEnchantments.SLIDING_CURSE)) {
            Object[] objectArray = new Object[]{block};
            if (((Float)original.call(objectArray)).floatValue() >= 0.6f) {
                Object[] objectArray2 = new Object[]{block};
                if (((Float)original.call(objectArray2)).floatValue() < 0.98f) {
                    return 0.98f;
                }
            }
        }
        return ((Float)original.call(new Object[]{block})).floatValue();
    }
}

