/*
 * Decompiled with CFR 0.152.
 */
package net.legacy.enchants_and_expeditions.mixin.inventory;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.legacy.enchants_and_expeditions.EnchantsAndExpeditions;
import net.legacy.enchants_and_expeditions.block.AltarBlock;
import net.legacy.enchants_and_expeditions.block.AltarBlockType;
import net.legacy.enchants_and_expeditions.config.EaEConfig;
import net.legacy.enchants_and_expeditions.lib.EnchantingHelper;
import net.legacy.enchants_and_expeditions.network.EnchantingAttributes;
import net.legacy.enchants_and_expeditions.registry.EaEBlocks;
import net.legacy.enchants_and_expeditions.tag.EaEEnchantmentTags;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9889;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1718.class})
public abstract class EnchantmentMenuMixin
implements EnchantingAttributes {
    @Shadow
    @Final
    private class_5819 field_7811;
    @Shadow
    @Final
    private class_3915 field_7814;
    @Shadow
    @Final
    private class_1263 field_7809;
    @Shadow
    @Final
    private class_3914 field_7813;
    @Shadow
    @Final
    public int[] field_7808;
    @Shadow
    @Final
    public int[] field_7812;
    @Shadow
    @Final
    public int[] field_7810;
    @Unique
    private class_1657 player;
    @Unique
    private int totalBookshelves = 0;
    @Unique
    private int bookshelves = 0;
    @Unique
    private int arcaneBooksheves = 0;
    @Unique
    private int glacialBooksheves = 0;
    @Unique
    private int infernalBooksheves = 0;
    @Unique
    private int totalAltars = 0;
    @Unique
    private int manaAltars = 0;
    @Unique
    private int frostAltars = 0;
    @Unique
    private int scorchAltars = 0;
    @Unique
    private int flowAltars = 0;
    @Unique
    private int chaosAltars = 0;
    @Unique
    private int greedAltars = 0;
    @Unique
    private int mightAltars = 0;
    @Unique
    private int stabilityAltars = 0;
    @Unique
    private int powerAltars = 0;
    @Unique
    private int mana = 0;
    @Unique
    private int frost = 0;
    @Unique
    private int scorch = 0;
    @Unique
    private int flow = 0;
    @Unique
    private int chaos = 0;
    @Unique
    private int greed = 0;
    @Unique
    private int might = 0;
    @Unique
    private int corruption = 0;
    @Unique
    private int divinity = 0;

    @Shadow
    protected abstract List<class_1889> method_7637(class_5455 var1, class_1799 var2, int var3, int var4);

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/inventory/ContainerLevelAccess;)V"}, at={@At(value="TAIL")})
    private void onInit(int syncId, class_1661 playerInventory, class_3914 access, CallbackInfo ci) {
        this.player = playerInventory.field_7546;
    }

    @Unique
    private static String EaE$blockId(class_2680 state) {
        try {
            return state.method_26204().method_40142().method_40237().method_29177().toString();
        }
        catch (Throwable t) {
            return state.method_26204().getClass().getSimpleName();
        }
    }

    @Unique
    private static boolean enchantingBlockCheck(class_1937 level, class_2338 enchantingTablePos, class_2338 bookshelfPos, class_2248 block) {
        class_2338 targetPos = enchantingTablePos.method_10081((class_2382)bookshelfPos);
        class_2338 gapPos = enchantingTablePos.method_10069(bookshelfPos.method_10263() / 2, bookshelfPos.method_10264(), bookshelfPos.method_10260() / 2);
        class_2680 targetState = level.method_8320(targetPos);
        class_2680 gapState = level.method_8320(gapPos);
        boolean isMatch = targetState.method_27852(block);
        boolean isTransmitter = gapState.method_26164(class_3481.field_44473);
        if (EnchantsAndExpeditions.debug) {
            LogUtils.getLogger().info("[EaE] check targetPos={} targetBlock={} expectMatch={} actualMatch={} gapPos={} gapBlock={} transmitterMatch={}", new Object[]{targetPos, EnchantmentMenuMixin.EaE$blockId(targetState), block.method_63499(), isMatch, gapPos, EnchantmentMenuMixin.EaE$blockId(gapState), isTransmitter});
        }
        return isMatch && isTransmitter;
    }

    @Unique
    private static class_2338 getAltarPos(class_2338 enchantingTablePos, class_2338 altarPos) {
        return enchantingTablePos.method_10081((class_2382)altarPos);
    }

    @Inject(method={"slotsChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void EaE$slotsChanged(class_1263 container, CallbackInfo ci) {
        class_1718 enchantmentMenu = (class_1718)class_1718.class.cast(this);
        if (container == this.field_7809) {
            class_1799 itemStack = container.method_5438(0);
            if (!itemStack.method_7960() && itemStack.method_7923()) {
                this.field_7813.method_17393((level, blockPos) -> {
                    class_2359 idMap = level.method_30349().method_30530(class_7924.field_41265).method_40295();
                    int ix = 0;
                    this.totalBookshelves = 0;
                    this.bookshelves = 0;
                    this.arcaneBooksheves = 0;
                    this.glacialBooksheves = 0;
                    this.infernalBooksheves = 0;
                    this.totalAltars = 0;
                    this.manaAltars = 0;
                    this.frostAltars = 0;
                    this.scorchAltars = 0;
                    this.flowAltars = 0;
                    this.chaosAltars = 0;
                    this.greedAltars = 0;
                    this.mightAltars = 0;
                    this.stabilityAltars = 0;
                    this.powerAltars = 0;
                    for (class_2338 off : class_2331.field_36535) {
                        if (class_2331.method_40445((class_1937)level, (class_2338)blockPos, (class_2338)off)) {
                            ++ix;
                        }
                        if (this.totalBookshelves < 15) {
                            if (EnchantmentMenuMixin.enchantingBlockCheck(level, blockPos, off, class_2246.field_10504)) {
                                ++this.bookshelves;
                                ++this.totalBookshelves;
                            }
                            if (EnchantmentMenuMixin.enchantingBlockCheck(level, blockPos, off, EaEBlocks.ARCANE_BOOKSHELF)) {
                                ++this.arcaneBooksheves;
                                ++this.totalBookshelves;
                            }
                            if (EnchantmentMenuMixin.enchantingBlockCheck(level, blockPos, off, EaEBlocks.GLACIAL_BOOKSHELF)) {
                                ++this.glacialBooksheves;
                                ++this.totalBookshelves;
                            }
                            if (EnchantmentMenuMixin.enchantingBlockCheck(level, blockPos, off, EaEBlocks.INFERNAL_BOOKSHELF)) {
                                ++this.infernalBooksheves;
                                ++this.totalBookshelves;
                            }
                        }
                        if (this.totalAltars >= 3 || !EnchantmentMenuMixin.enchantingBlockCheck(level, blockPos, off, EaEBlocks.ALTAR) || level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.EMPTY) continue;
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.MANA_TOME) {
                            ++this.manaAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.FROST_TOME) {
                            ++this.frostAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.SCORCH_TOME) {
                            ++this.scorchAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.FLOW_TOME) {
                            ++this.flowAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.CHAOS_TOME) {
                            ++this.chaosAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.GREED_TOME) {
                            ++this.greedAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.MIGHT_TOME) {
                            ++this.mightAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.STABILITY_TOME) {
                            ++this.stabilityAltars;
                            ++this.totalAltars;
                        }
                        if (level.method_8320(EnchantmentMenuMixin.getAltarPos(blockPos, off)).method_11654(AltarBlock.TOME) != AltarBlockType.POWER_TOME) continue;
                        ++this.powerAltars;
                        ++this.totalAltars;
                    }
                    this.field_7811.method_43052((long)this.field_7814.method_17407());
                    for (int j = 0; j < 3; ++j) {
                        this.field_7808[j] = class_1890.method_8227((class_5819)this.field_7811, (int)j, (int)ix, (class_1799)itemStack);
                        if (this.field_7808[j] >= 1) {
                            int n = j;
                            this.field_7808[n] = this.field_7808[n] + (itemStack.method_58657().method_57541() * 3 + EnchantingHelper.getBlessings(itemStack) * 3 - EnchantingHelper.getCurses(itemStack) * 3 + this.totalAltars * 3 - this.stabilityAltars * 6 - this.powerAltars * 6);
                        }
                        if (class_1890.method_8227((class_5819)this.field_7811, (int)j, (int)ix, (class_1799)itemStack) >= 1) {
                            if (this.field_7808[0] < 1) {
                                this.field_7808[0] = 1;
                            } else if (this.field_7808[1] < 2) {
                                this.field_7808[1] = 2;
                            } else if (this.field_7808[2] < 3) {
                                this.field_7808[2] = 3;
                            }
                        }
                        this.field_7812[j] = -1;
                        this.field_7810[j] = -1;
                        if (this.field_7808[j] >= j + 1) continue;
                        this.field_7808[j] = 0;
                    }
                    for (int jx = 0; jx < 3; ++jx) {
                        List<class_1889> list;
                        if (this.field_7808[jx] <= 0 || (list = this.method_7637(level.method_30349(), itemStack, jx, this.field_7808[jx] + this.powerAltars * 3 + this.stabilityAltars * 3)) == null || list.isEmpty()) continue;
                        class_1889 inst = list.get(this.field_7811.method_43048(list.size()));
                        this.field_7812[jx] = idMap.method_10206((Object)inst.comp_3486());
                        this.field_7810[jx] = inst.comp_3487();
                    }
                    enchantmentMenu.method_7623();
                });
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.field_7808[i] = 0;
                    this.field_7812[i] = -1;
                    this.field_7810[i] = -1;
                }
            }
        }
        ci.cancel();
    }

    @Inject(method={"getEnchantmentList"}, at={@At(value="HEAD")}, cancellable=true)
    private void EaE$getEnchantmentList(class_5455 registryAccess, class_1799 stack, int slot, int enchantingPower, CallbackInfoReturnable<List<class_1889>> cir) {
        this.field_7811.method_43052((long)(this.field_7814.method_17407() + slot));
        if (!stack.method_57353().method_57832(class_9334.field_53695)) {
            cir.setReturnValue(List.of());
        } else {
            List<class_1889> list = this.EaE$selectEnchantment(this.field_7811, stack, slot, enchantingPower, registryAccess);
            cir.setReturnValue(list);
        }
    }

    @Unique
    private List<class_1889> EaE$selectEnchantment(class_5819 random, class_1799 stack, int slot, int enchantingPower, class_5455 registryAccess) {
        ArrayList list = Lists.newArrayList();
        class_9889 enchantable = (class_9889)stack.method_58694(class_9334.field_53695);
        if (enchantable == null) {
            return list;
        }
        this.calculateAttributes();
        List baseEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.ENCHANTING_TABLE).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List manaEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.MANA).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List frostEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.FROST).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List scorchEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.SCORCH).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List flowEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.FLOW).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List chaosEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.CHAOS).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List greedEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.GREED).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List mightEnchantments = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.MIGHT).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List manaBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.MANA_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List frostBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.FROST_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List scorchBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.SCORCH_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List flowBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.FLOW_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List chaosBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.CHAOS_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List greedBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.GREED_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List mightBlessings = registryAccess.method_30530(class_7924.field_41265).method_46733(EaEEnchantmentTags.MIGHT_BLESSING).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        List corruptionCurses = registryAccess.method_30530(class_7924.field_41265).method_46733(class_9636.field_51551).map(class_6885.class_6887::method_40239).orElse(Stream.empty()).toList();
        int enchantability = Math.max(0, enchantable.comp_2938() + this.powerAltars * 3 - this.stabilityAltars * 3);
        enchantingPower += 1 + random.method_43048(enchantability / 4 + 1) + random.method_43048(enchantability / 4 + 1);
        float f = (random.method_43057() + random.method_43057() - 1.0f) * 0.15f;
        enchantingPower = class_3532.method_15340((int)Math.round((float)enchantingPower + (float)enchantingPower * f), (int)1, (int)Integer.MAX_VALUE);
        List<class_1889> baseList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, baseEnchantments.stream());
        List<class_1889> manaList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, manaEnchantments.stream());
        List<class_1889> frostList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, frostEnchantments.stream());
        List<class_1889> scorchList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, scorchEnchantments.stream());
        List<class_1889> flowList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, flowEnchantments.stream());
        List<class_1889> chaosList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, chaosEnchantments.stream());
        List<class_1889> greedList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, greedEnchantments.stream());
        List<class_1889> mightList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, mightEnchantments.stream());
        List<class_1889> manaBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, manaBlessings.stream());
        List<class_1889> frostBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, frostBlessings.stream());
        List<class_1889> scorchBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, scorchBlessings.stream());
        List<class_1889> flowBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, flowBlessings.stream());
        List<class_1889> chaosBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, chaosBlessings.stream());
        List<class_1889> greedBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, greedBlessings.stream());
        List<class_1889> mightBlessingList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, mightBlessings.stream());
        List<class_1889> curseList = class_1890.method_8229((int)enchantingPower, (class_1799)stack, corruptionCurses.stream());
        baseList = EnchantingHelper.evaluateEnchantments(stack, baseList);
        manaList = EnchantingHelper.evaluateEnchantments(stack, manaList);
        frostList = EnchantingHelper.evaluateEnchantments(stack, frostList);
        scorchList = EnchantingHelper.evaluateEnchantments(stack, scorchList);
        flowList = EnchantingHelper.evaluateEnchantments(stack, flowList);
        chaosList = EnchantingHelper.evaluateEnchantments(stack, chaosList);
        greedList = EnchantingHelper.evaluateEnchantments(stack, greedList);
        mightList = EnchantingHelper.evaluateEnchantments(stack, mightList);
        manaBlessingList = EnchantingHelper.evaluateEnchantments(stack, manaBlessingList);
        frostBlessingList = EnchantingHelper.evaluateEnchantments(stack, frostBlessingList);
        scorchBlessingList = EnchantingHelper.evaluateEnchantments(stack, scorchBlessingList);
        flowBlessingList = EnchantingHelper.evaluateEnchantments(stack, flowBlessingList);
        chaosBlessingList = EnchantingHelper.evaluateEnchantments(stack, chaosBlessingList);
        greedBlessingList = EnchantingHelper.evaluateEnchantments(stack, greedBlessingList);
        mightBlessingList = EnchantingHelper.evaluateEnchantments(stack, mightBlessingList);
        curseList = EnchantingHelper.evaluateEnchantments(stack, curseList);
        if (baseList.isEmpty() && manaList.isEmpty() && frostList.isEmpty() && scorchList.isEmpty() && flowList.isEmpty() && chaosList.isEmpty() && greedList.isEmpty() && mightList.isEmpty() && manaBlessingList.isEmpty() && frostBlessingList.isEmpty() && scorchBlessingList.isEmpty() && flowBlessingList.isEmpty() && chaosBlessingList.isEmpty() && greedBlessingList.isEmpty() && mightBlessingList.isEmpty() && curseList.isEmpty()) {
            return list;
        }
        boolean firstEnchant = false;
        for (int attempts = 0; (random.method_43048(50) <= enchantingPower || !firstEnchant || list.isEmpty()) && attempts < 10; ++attempts) {
            if (!list.isEmpty()) {
                class_1890.method_8231(baseList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(manaList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(frostList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(scorchList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(flowList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(chaosList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(greedList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(mightList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(manaBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(frostBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(scorchBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(flowBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(chaosBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(greedBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(mightBlessingList, (class_1889)((class_1889)class_156.method_20793((List)list)));
                class_1890.method_8231(curseList, (class_1889)((class_1889)class_156.method_20793((List)list)));
            }
            int manaBlessingWeight = Math.max(0, this.manaAltars * 3);
            int frostBlessingWeight = Math.max(0, this.frostAltars * 3);
            int scorchBlessingWeight = Math.max(0, this.scorchAltars * 3);
            int flowBlessingWeight = Math.max(0, this.flowAltars * 3);
            int chaosBlessingWeight = Math.max(0, this.chaosAltars * 3);
            int greedBlessingWeight = Math.max(0, this.greedAltars * 3);
            int mightBlessingWeight = Math.max(0, this.mightAltars * 3);
            int curseWeight = Math.max(0, this.corruption * 3);
            int totalWeight = this.mana + this.frost + this.scorch + this.flow + this.chaos + this.greed + this.might + curseWeight + manaBlessingWeight + frostBlessingWeight + scorchBlessingWeight + flowBlessingWeight + chaosBlessingWeight + greedBlessingWeight + mightBlessingWeight;
            if (totalWeight <= 0) {
                class_6011.method_34986((class_5819)random, baseList, class_1889::method_66344).ifPresent(list::add);
            }
            int randomValue = random.method_43048(totalWeight);
            int cumulative = 0;
            if (randomValue < (cumulative += this.mana)) {
                class_6011.method_34986((class_5819)random, manaList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.frost)) {
                class_6011.method_34986((class_5819)random, frostList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.scorch)) {
                class_6011.method_34986((class_5819)random, scorchList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.flow)) {
                class_6011.method_34986((class_5819)random, flowList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.chaos)) {
                class_6011.method_34986((class_5819)random, chaosList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.greed)) {
                class_6011.method_34986((class_5819)random, greedList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += this.might)) {
                class_6011.method_34986((class_5819)random, mightList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += manaBlessingWeight)) {
                class_6011.method_34986((class_5819)random, manaBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += frostBlessingWeight)) {
                class_6011.method_34986((class_5819)random, frostBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += scorchBlessingWeight)) {
                class_6011.method_34986((class_5819)random, scorchBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += flowBlessingWeight)) {
                class_6011.method_34986((class_5819)random, flowBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += chaosBlessingWeight)) {
                class_6011.method_34986((class_5819)random, chaosBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += greedBlessingWeight)) {
                class_6011.method_34986((class_5819)random, greedBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += mightBlessingWeight)) {
                class_6011.method_34986((class_5819)random, mightBlessingList, class_1889::method_66344).ifPresent(list::add);
            } else if (randomValue < (cumulative += curseWeight)) {
                class_6011.method_34986((class_5819)random, curseList, class_1889::method_66344).ifPresent(list::add);
            }
            if (!firstEnchant) {
                firstEnchant = true;
                continue;
            }
            if (list.isEmpty()) {
                enchantingPower *= 2;
                continue;
            }
            if (slot + 1 > list.size() && EaEConfig.get.general.enchantment_limit >= 3) continue;
            enchantingPower /= 2;
        }
        while (list.size() + EnchantingHelper.enchantmentScore(stack) > EaEConfig.get.general.enchantment_limit && EaEConfig.get.general.enchantment_limit >= 1) {
            list.remove(random.method_43048(list.size()));
        }
        return list;
    }

    @Override
    public EnchantingAttributes.Attributes calculateAttributes() {
        EnchantingAttributes.Attributes result = (EnchantingAttributes.Attributes)this.field_7813.method_17396((level, tablePos) -> {
            int tBooks = 0;
            int nBooks = 0;
            int aBooks = 0;
            int gBooks = 0;
            int iBooks = 0;
            int tAltars = 0;
            int aMana = 0;
            int aFrost = 0;
            int aScorch = 0;
            int aFlow = 0;
            int aChaos = 0;
            int aGreed = 0;
            int aMight = 0;
            int aStability = 0;
            int aPower = 0;
            for (class_2338 off : class_2331.field_36535) {
                if (tBooks < 15) {
                    if (EnchantmentMenuMixin.enchantingBlockCheck(level, tablePos, off, class_2246.field_10504)) {
                        ++nBooks;
                        ++tBooks;
                    }
                    if (EnchantmentMenuMixin.enchantingBlockCheck(level, tablePos, off, EaEBlocks.ARCANE_BOOKSHELF)) {
                        ++aBooks;
                        ++tBooks;
                    }
                    if (EnchantmentMenuMixin.enchantingBlockCheck(level, tablePos, off, EaEBlocks.GLACIAL_BOOKSHELF)) {
                        ++gBooks;
                        ++tBooks;
                    }
                    if (EnchantmentMenuMixin.enchantingBlockCheck(level, tablePos, off, EaEBlocks.INFERNAL_BOOKSHELF)) {
                        ++iBooks;
                        ++tBooks;
                    }
                }
                if (tAltars >= 3 || !EnchantmentMenuMixin.enchantingBlockCheck(level, tablePos, off, EaEBlocks.ALTAR) || level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.EMPTY) continue;
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.MANA_TOME) {
                    ++aMana;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.FROST_TOME) {
                    ++aFrost;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.SCORCH_TOME) {
                    ++aScorch;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.FLOW_TOME) {
                    ++aFlow;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.CHAOS_TOME) {
                    ++aChaos;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.GREED_TOME) {
                    ++aGreed;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.MIGHT_TOME) {
                    ++aMight;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) == AltarBlockType.STABILITY_TOME) {
                    ++aStability;
                    ++tAltars;
                }
                if (level.method_8320(EnchantmentMenuMixin.getAltarPos(tablePos, off)).method_11654(AltarBlock.TOME) != AltarBlockType.POWER_TOME) continue;
                ++aPower;
                ++tAltars;
            }
            int locMana = 0;
            int locFrost = 0;
            int locScorch = 0;
            int locFlow = 0;
            int locChaos = 0;
            int locGreed = 0;
            int locMight = 0;
            int locCorruption = 0;
            int locDivinity = 0;
            locMana += nBooks / 2;
            locFrost += nBooks / 4;
            locScorch += nBooks / 4;
            locFlow += nBooks / 4;
            locChaos += nBooks / 4;
            locGreed += nBooks / 4;
            locMight += nBooks / 4;
            locMana += aBooks;
            locFlow += aBooks / 2;
            locGreed += aBooks / 2;
            locMight += aBooks / 4;
            locFrost += gBooks;
            locFlow += gBooks / 2;
            locChaos += gBooks / 2;
            locMight += gBooks / 4;
            locScorch += iBooks;
            locGreed += iBooks / 2;
            locChaos += iBooks / 2;
            locMight += iBooks / 4;
            locMana += aMana * 3;
            locChaos -= aMana * 5;
            locCorruption += aMana;
            locDivinity += aMana;
            locFrost += aFrost * 3;
            locScorch -= aFrost * 5;
            locCorruption += aFrost;
            locDivinity += aFrost;
            locScorch += aScorch * 3;
            locFrost -= aScorch * 5;
            locCorruption += aScorch;
            locDivinity += aScorch;
            locFlow += aFlow * 5;
            locCorruption += aFlow;
            locGreed -= aFlow * 3;
            locDivinity += aFlow;
            locChaos += aChaos * 5;
            locCorruption += aChaos;
            locMana -= aChaos * 3;
            locDivinity += aChaos;
            locGreed += aGreed * 5;
            locCorruption += aGreed;
            locFlow -= aGreed * 3;
            locDivinity += aGreed;
            locMight += aMight * 5;
            locCorruption += aMight;
            locChaos -= aMight;
            locGreed -= aMight;
            locFlow -= aMight;
            locScorch -= aMight;
            locFrost -= aMight;
            locMana -= aMight;
            locDivinity += aMight;
            locCorruption -= aStability;
            locMight -= aPower * 5;
            locChaos += aPower;
            locGreed += aPower;
            locFlow += aPower;
            locScorch += aPower;
            locFrost += aPower;
            locMana += aPower;
            this.totalBookshelves = tBooks;
            this.bookshelves = nBooks;
            this.arcaneBooksheves = aBooks;
            this.glacialBooksheves = gBooks;
            this.infernalBooksheves = iBooks;
            this.totalAltars = tAltars;
            this.manaAltars = aMana;
            this.frostAltars = aFrost;
            this.scorchAltars = aScorch;
            this.flowAltars = aFlow;
            this.chaosAltars = aChaos;
            this.greedAltars = aGreed;
            this.mightAltars = aMight;
            this.stabilityAltars = aStability;
            this.powerAltars = aPower;
            this.mana = locMana;
            this.frost = locFrost;
            this.scorch = locScorch;
            this.flow = locFlow;
            this.chaos = locChaos;
            this.greed = locGreed;
            this.might = locMight;
            this.corruption = locCorruption;
            this.divinity = locDivinity;
            return new EnchantingAttributes.Attributes(locMana, locFrost, locScorch, locFlow, locChaos, locGreed, locMight, locCorruption, locDivinity);
        }, (Object)new EnchantingAttributes.Attributes(this.mana, this.frost, this.scorch, this.flow, this.chaos, this.greed, this.might, this.corruption, this.divinity));
        return result;
    }
}

