/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.theangryghast.client.model.animations.angry_ghastAnimation;
import net.theangryghast.entity.NetherfishEntity;

public class NetherfishRenderer
extends MobRenderer<NetherfishEntity, SilverfishModel<NetherfishEntity>> {
    public NetherfishRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelLayers.SILVERFISH)), 0.5f);
    }

    protected void scale(NetherfishEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.2f, 1.2f, 1.2f);
    }

    public ResourceLocation getTextureLocation(NetherfishEntity entity) {
        return ResourceLocation.parse((String)"the_angry_ghast:textures/entities/netherfish.png");
    }

    private static final class AnimatedModel
    extends SilverfishModel<NetherfishEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<NetherfishEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(NetherfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, angry_ghastAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupAnim(NetherfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

