/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.theangryghast.procedures.AngrierGhastEntityDiesProcedure;
import net.theangryghast.procedures.AngrierGhastOnentityTickUpdateProcedure;

public class AngrierGhastEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_shooting_texture = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shooting_timer = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_already_shot = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shooting_phase = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_smoking = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_phase_change_timer = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_phase = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_targetting_for_assault = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_assaulting = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_assault_timer = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_assault_delay = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_active_delay = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_reset_delay = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_active_reset_delay = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_netherfish_timer = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_living_sound_timer = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_smoking_sound = SynchedEntityData.defineId(AngrierGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public AngrierGhastEntity(EntityType<AngrierGhastEntity> type, Level world) {
        super(type, world);
        this.xpReward = 38;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_shooting_texture, (Object)false);
        builder.define(DATA_shooting_timer, (Object)0);
        builder.define(DATA_already_shot, (Object)false);
        builder.define(DATA_shooting_phase, (Object)1);
        builder.define(DATA_smoking, (Object)false);
        builder.define(DATA_phase_change_timer, (Object)800);
        builder.define(DATA_battle_phase, (Object)2);
        builder.define(DATA_targetting_for_assault, (Object)false);
        builder.define(DATA_assaulting, (Object)false);
        builder.define(DATA_assault_timer, (Object)80);
        builder.define(DATA_assault_delay, (Object)90);
        builder.define(DATA_active_delay, (Object)false);
        builder.define(DATA_reset_delay, (Object)40);
        builder.define(DATA_active_reset_delay, (Object)false);
        builder.define(DATA_netherfish_timer, (Object)300);
        builder.define(DATA_living_sound_timer, (Object)0);
        builder.define(DATA_smoking_sound, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return AngrierGhastEntity.this.getTarget() != null && !AngrierGhastEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return AngrierGhastEntity.this.getMoveControl().hasWanted() && AngrierGhastEntity.this.getTarget() != null && AngrierGhastEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AngrierGhastEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AngrierGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
            }

            public void tick() {
                LivingEntity livingentity = AngrierGhastEntity.this.getTarget();
                if (AngrierGhastEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AngrierGhastEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = AngrierGhastEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 64.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AngrierGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1, 20){

            protected Vec3 getPosition() {
                RandomSource random = AngrierGhastEntity.this.getRandom();
                double dir_x = AngrierGhastEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AngrierGhastEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AngrierGhastEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        AngrierGhastEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datashooting_texture", ((Boolean)this.entityData.get(DATA_shooting_texture)).booleanValue());
        compound.putInt("Datashooting_timer", ((Integer)this.entityData.get(DATA_shooting_timer)).intValue());
        compound.putBoolean("Dataalready_shot", ((Boolean)this.entityData.get(DATA_already_shot)).booleanValue());
        compound.putInt("Datashooting_phase", ((Integer)this.entityData.get(DATA_shooting_phase)).intValue());
        compound.putBoolean("Datasmoking", ((Boolean)this.entityData.get(DATA_smoking)).booleanValue());
        compound.putInt("Dataphase_change_timer", ((Integer)this.entityData.get(DATA_phase_change_timer)).intValue());
        compound.putInt("Databattle_phase", ((Integer)this.entityData.get(DATA_battle_phase)).intValue());
        compound.putBoolean("Datatargetting_for_assault", ((Boolean)this.entityData.get(DATA_targetting_for_assault)).booleanValue());
        compound.putBoolean("Dataassaulting", ((Boolean)this.entityData.get(DATA_assaulting)).booleanValue());
        compound.putInt("Dataassault_timer", ((Integer)this.entityData.get(DATA_assault_timer)).intValue());
        compound.putInt("Dataassault_delay", ((Integer)this.entityData.get(DATA_assault_delay)).intValue());
        compound.putBoolean("Dataactive_delay", ((Boolean)this.entityData.get(DATA_active_delay)).booleanValue());
        compound.putInt("Datareset_delay", ((Integer)this.entityData.get(DATA_reset_delay)).intValue());
        compound.putBoolean("Dataactive_reset_delay", ((Boolean)this.entityData.get(DATA_active_reset_delay)).booleanValue());
        compound.putInt("Datanetherfish_timer", ((Integer)this.entityData.get(DATA_netherfish_timer)).intValue());
        compound.putInt("Dataliving_sound_timer", ((Integer)this.entityData.get(DATA_living_sound_timer)).intValue());
        compound.putBoolean("Datasmoking_sound", ((Boolean)this.entityData.get(DATA_smoking_sound)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datashooting_texture")) {
            this.entityData.set(DATA_shooting_texture, (Object)compound.getBoolean("Datashooting_texture"));
        }
        if (compound.contains("Datashooting_timer")) {
            this.entityData.set(DATA_shooting_timer, (Object)compound.getInt("Datashooting_timer"));
        }
        if (compound.contains("Dataalready_shot")) {
            this.entityData.set(DATA_already_shot, (Object)compound.getBoolean("Dataalready_shot"));
        }
        if (compound.contains("Datashooting_phase")) {
            this.entityData.set(DATA_shooting_phase, (Object)compound.getInt("Datashooting_phase"));
        }
        if (compound.contains("Datasmoking")) {
            this.entityData.set(DATA_smoking, (Object)compound.getBoolean("Datasmoking"));
        }
        if (compound.contains("Dataphase_change_timer")) {
            this.entityData.set(DATA_phase_change_timer, (Object)compound.getInt("Dataphase_change_timer"));
        }
        if (compound.contains("Databattle_phase")) {
            this.entityData.set(DATA_battle_phase, (Object)compound.getInt("Databattle_phase"));
        }
        if (compound.contains("Datatargetting_for_assault")) {
            this.entityData.set(DATA_targetting_for_assault, (Object)compound.getBoolean("Datatargetting_for_assault"));
        }
        if (compound.contains("Dataassaulting")) {
            this.entityData.set(DATA_assaulting, (Object)compound.getBoolean("Dataassaulting"));
        }
        if (compound.contains("Dataassault_timer")) {
            this.entityData.set(DATA_assault_timer, (Object)compound.getInt("Dataassault_timer"));
        }
        if (compound.contains("Dataassault_delay")) {
            this.entityData.set(DATA_assault_delay, (Object)compound.getInt("Dataassault_delay"));
        }
        if (compound.contains("Dataactive_delay")) {
            this.entityData.set(DATA_active_delay, (Object)compound.getBoolean("Dataactive_delay"));
        }
        if (compound.contains("Datareset_delay")) {
            this.entityData.set(DATA_reset_delay, (Object)compound.getInt("Datareset_delay"));
        }
        if (compound.contains("Dataactive_reset_delay")) {
            this.entityData.set(DATA_active_reset_delay, (Object)compound.getBoolean("Dataactive_reset_delay"));
        }
        if (compound.contains("Datanetherfish_timer")) {
            this.entityData.set(DATA_netherfish_timer, (Object)compound.getInt("Datanetherfish_timer"));
        }
        if (compound.contains("Dataliving_sound_timer")) {
            this.entityData.set(DATA_living_sound_timer, (Object)compound.getInt("Dataliving_sound_timer"));
        }
        if (compound.contains("Datasmoking_sound")) {
            this.entityData.set(DATA_smoking_sound, (Object)compound.getBoolean("Datasmoking_sound"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        AngrierGhastOnentityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(3.9f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 10.0);
        builder = builder.add(Attributes.MAX_HEALTH, 615.0);
        builder = builder.add(Attributes.ARMOR, 1.2);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 22.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 15.0);
        builder = builder.add(Attributes.FLYING_SPEED, 10.0);
        return builder;
    }
}

