/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.theangryghast.procedures.AngriestGhastMoveConditionForAiProcedure;
import net.theangryghast.procedures.AngriestGhastOnEntityTickUpdateProcedure;
import net.theangryghast.procedures.AngriestGhastOnInitialEntitySpawnProcedure;

public class AngriestGhastEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_shooting_texture = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shooting_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_already_shot = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_phase_change_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_phase = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_teleporting = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_idle_teleport_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_ghastling_spawn_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_crystals_id = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> DATA_can_move = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_living_sound_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_crystals_sound_timer = SynchedEntityData.defineId(AngriestGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public AngriestGhastEntity(EntityType<AngriestGhastEntity> type, Level world) {
        super(type, world);
        this.xpReward = 46;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_shooting_texture, (Object)false);
        builder.define(DATA_shooting_timer, (Object)0);
        builder.define(DATA_already_shot, (Object)false);
        builder.define(DATA_phase_change_timer, (Object)800);
        builder.define(DATA_battle_phase, (Object)1);
        builder.define(DATA_teleporting, (Object)false);
        builder.define(DATA_idle_teleport_timer, (Object)170);
        builder.define(DATA_ghastling_spawn_timer, (Object)420);
        builder.define(DATA_crystals_id, (Object)"");
        builder.define(DATA_can_move, (Object)true);
        builder.define(DATA_living_sound_timer, (Object)0);
        builder.define(DATA_crystals_sound_timer, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                if (AngriestGhastEntity.this.getTarget() != null && !AngriestGhastEntity.this.getMoveControl().hasWanted()) {
                    double x = AngriestGhastEntity.this.getX();
                    double y = AngriestGhastEntity.this.getY();
                    double z = AngriestGhastEntity.this.getZ();
                    AngriestGhastEntity entity = AngriestGhastEntity.this;
                    Level world = AngriestGhastEntity.this.level();
                    return AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
                }
                return false;
            }

            public boolean canContinueToUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity) && AngriestGhastEntity.this.getMoveControl().hasWanted() && AngriestGhastEntity.this.getTarget() != null && AngriestGhastEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AngriestGhastEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AngriestGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
            }

            public void tick() {
                LivingEntity livingentity = AngriestGhastEntity.this.getTarget();
                if (AngriestGhastEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AngriestGhastEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = AngriestGhastEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 64.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AngriestGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1, 20){

            protected Vec3 getPosition() {
                RandomSource random = AngriestGhastEntity.this.getRandom();
                double dir_x = AngriestGhastEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AngriestGhastEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AngriestGhastEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canContinueToUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canContinueToUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = AngriestGhastEntity.this.getX();
                double y = AngriestGhastEntity.this.getY();
                double z = AngriestGhastEntity.this.getZ();
                AngriestGhastEntity entity = AngriestGhastEntity.this;
                Level world = AngriestGhastEntity.this.level();
                return super.canContinueToUse() && AngriestGhastMoveConditionForAiProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AngriestGhastOnInitialEntitySpawnProcedure.execute((Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datashooting_texture", ((Boolean)this.entityData.get(DATA_shooting_texture)).booleanValue());
        compound.putInt("Datashooting_timer", ((Integer)this.entityData.get(DATA_shooting_timer)).intValue());
        compound.putBoolean("Dataalready_shot", ((Boolean)this.entityData.get(DATA_already_shot)).booleanValue());
        compound.putInt("Dataphase_change_timer", ((Integer)this.entityData.get(DATA_phase_change_timer)).intValue());
        compound.putInt("Databattle_phase", ((Integer)this.entityData.get(DATA_battle_phase)).intValue());
        compound.putBoolean("Datateleporting", ((Boolean)this.entityData.get(DATA_teleporting)).booleanValue());
        compound.putInt("Dataidle_teleport_timer", ((Integer)this.entityData.get(DATA_idle_teleport_timer)).intValue());
        compound.putInt("Dataghastling_spawn_timer", ((Integer)this.entityData.get(DATA_ghastling_spawn_timer)).intValue());
        compound.putString("Datacrystals_id", (String)this.entityData.get(DATA_crystals_id));
        compound.putBoolean("Datacan_move", ((Boolean)this.entityData.get(DATA_can_move)).booleanValue());
        compound.putInt("Dataliving_sound_timer", ((Integer)this.entityData.get(DATA_living_sound_timer)).intValue());
        compound.putInt("Datacrystals_sound_timer", ((Integer)this.entityData.get(DATA_crystals_sound_timer)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datashooting_texture")) {
            this.entityData.set(DATA_shooting_texture, (Object)compound.getBoolean("Datashooting_texture"));
        }
        if (compound.contains("Datashooting_timer")) {
            this.entityData.set(DATA_shooting_timer, (Object)compound.getInt("Datashooting_timer"));
        }
        if (compound.contains("Dataalready_shot")) {
            this.entityData.set(DATA_already_shot, (Object)compound.getBoolean("Dataalready_shot"));
        }
        if (compound.contains("Dataphase_change_timer")) {
            this.entityData.set(DATA_phase_change_timer, (Object)compound.getInt("Dataphase_change_timer"));
        }
        if (compound.contains("Databattle_phase")) {
            this.entityData.set(DATA_battle_phase, (Object)compound.getInt("Databattle_phase"));
        }
        if (compound.contains("Datateleporting")) {
            this.entityData.set(DATA_teleporting, (Object)compound.getBoolean("Datateleporting"));
        }
        if (compound.contains("Dataidle_teleport_timer")) {
            this.entityData.set(DATA_idle_teleport_timer, (Object)compound.getInt("Dataidle_teleport_timer"));
        }
        if (compound.contains("Dataghastling_spawn_timer")) {
            this.entityData.set(DATA_ghastling_spawn_timer, (Object)compound.getInt("Dataghastling_spawn_timer"));
        }
        if (compound.contains("Datacrystals_id")) {
            this.entityData.set(DATA_crystals_id, (Object)compound.getString("Datacrystals_id"));
        }
        if (compound.contains("Datacan_move")) {
            this.entityData.set(DATA_can_move, (Object)compound.getBoolean("Datacan_move"));
        }
        if (compound.contains("Dataliving_sound_timer")) {
            this.entityData.set(DATA_living_sound_timer, (Object)compound.getInt("Dataliving_sound_timer"));
        }
        if (compound.contains("Datacrystals_sound_timer")) {
            this.entityData.set(DATA_crystals_sound_timer, (Object)compound.getInt("Datacrystals_sound_timer"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        AngriestGhastOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(3.9f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 10.0);
        builder = builder.add(Attributes.MAX_HEALTH, 680.0);
        builder = builder.add(Attributes.ARMOR, 1.2);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 22.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 15.0);
        builder = builder.add(Attributes.FLYING_SPEED, 10.0);
        return builder;
    }
}

