/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.theangryghast.procedures.AngryGhastOnEntityTickUpdateProcedure;

public class AngryGhastEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_shooting_texture = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_shooting_timer = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_already_shot = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_smash_attack = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_smash_timer = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_freeze_timer = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_ghastling_spawn_timer = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_living_sound_timer = SynchedEntityData.defineId(AngryGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public AngryGhastEntity(EntityType<AngryGhastEntity> type, Level world) {
        super(type, world);
        this.xpReward = 26;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_shooting_texture, (Object)false);
        builder.define(DATA_shooting_timer, (Object)0);
        builder.define(DATA_already_shot, (Object)false);
        builder.define(DATA_smash_attack, (Object)false);
        builder.define(DATA_smash_timer, (Object)0);
        builder.define(DATA_freeze_timer, (Object)0);
        builder.define(DATA_ghastling_spawn_timer, (Object)400);
        builder.define(DATA_living_sound_timer, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return AngryGhastEntity.this.getTarget() != null && !AngryGhastEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return AngryGhastEntity.this.getMoveControl().hasWanted() && AngryGhastEntity.this.getTarget() != null && AngryGhastEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AngryGhastEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AngryGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
            }

            public void tick() {
                LivingEntity livingentity = AngryGhastEntity.this.getTarget();
                if (AngryGhastEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AngryGhastEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = AngryGhastEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 64.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AngryGhastEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 0.1);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1, 20){

            protected Vec3 getPosition() {
                RandomSource random = AngryGhastEntity.this.getRandom();
                double dir_x = AngryGhastEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AngryGhastEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AngryGhastEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof ThrownPotion || damagesource.getDirectEntity() instanceof AreaEffectCloud || damagesource.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (damagesource.is(DamageTypes.WITHER) || damagesource.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datashooting_texture", ((Boolean)this.entityData.get(DATA_shooting_texture)).booleanValue());
        compound.putInt("Datashooting_timer", ((Integer)this.entityData.get(DATA_shooting_timer)).intValue());
        compound.putBoolean("Dataalready_shot", ((Boolean)this.entityData.get(DATA_already_shot)).booleanValue());
        compound.putBoolean("Datasmash_attack", ((Boolean)this.entityData.get(DATA_smash_attack)).booleanValue());
        compound.putInt("Datasmash_timer", ((Integer)this.entityData.get(DATA_smash_timer)).intValue());
        compound.putInt("Datafreeze_timer", ((Integer)this.entityData.get(DATA_freeze_timer)).intValue());
        compound.putInt("Dataghastling_spawn_timer", ((Integer)this.entityData.get(DATA_ghastling_spawn_timer)).intValue());
        compound.putInt("Dataliving_sound_timer", ((Integer)this.entityData.get(DATA_living_sound_timer)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datashooting_texture")) {
            this.entityData.set(DATA_shooting_texture, (Object)compound.getBoolean("Datashooting_texture"));
        }
        if (compound.contains("Datashooting_timer")) {
            this.entityData.set(DATA_shooting_timer, (Object)compound.getInt("Datashooting_timer"));
        }
        if (compound.contains("Dataalready_shot")) {
            this.entityData.set(DATA_already_shot, (Object)compound.getBoolean("Dataalready_shot"));
        }
        if (compound.contains("Datasmash_attack")) {
            this.entityData.set(DATA_smash_attack, (Object)compound.getBoolean("Datasmash_attack"));
        }
        if (compound.contains("Datasmash_timer")) {
            this.entityData.set(DATA_smash_timer, (Object)compound.getInt("Datasmash_timer"));
        }
        if (compound.contains("Datafreeze_timer")) {
            this.entityData.set(DATA_freeze_timer, (Object)compound.getInt("Datafreeze_timer"));
        }
        if (compound.contains("Dataghastling_spawn_timer")) {
            this.entityData.set(DATA_ghastling_spawn_timer, (Object)compound.getInt("Dataghastling_spawn_timer"));
        }
        if (compound.contains("Dataliving_sound_timer")) {
            this.entityData.set(DATA_living_sound_timer, (Object)compound.getInt("Dataliving_sound_timer"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        AngryGhastOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(3.9f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 10.0);
        builder = builder.add(Attributes.MAX_HEALTH, 530.0);
        builder = builder.add(Attributes.ARMOR, 1.5);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 22.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        builder = builder.add(Attributes.FLYING_SPEED, 10.0);
        return builder;
    }
}

