/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.theangryghast.procedures.AngryGhastlingFriendlyVariantOnEntityTickUpdateProcedure;

public class AngryGhastlingFriendlyVariantEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_living_sound_timer = SynchedEntityData.defineId(AngryGhastlingFriendlyVariantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_speed_mul = SynchedEntityData.defineId(AngryGhastlingFriendlyVariantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_speed_i = SynchedEntityData.defineId(AngryGhastlingFriendlyVariantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_despawn_timer = SynchedEntityData.defineId(AngryGhastlingFriendlyVariantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();

    public AngryGhastlingFriendlyVariantEntity(EntityType<AngryGhastlingFriendlyVariantEntity> type, Level world) {
        super(type, world);
        this.xpReward = 6;
        this.setNoAi(false);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_living_sound_timer, (Object)0);
        builder.define(DATA_speed_mul, (Object)0);
        builder.define(DATA_speed_i, (Object)0);
        builder.define(DATA_despawn_timer, (Object)0);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                return AngryGhastlingFriendlyVariantEntity.this.getTarget() != null && !AngryGhastlingFriendlyVariantEntity.this.getMoveControl().hasWanted();
            }

            public boolean canContinueToUse() {
                return AngryGhastlingFriendlyVariantEntity.this.getMoveControl().hasWanted() && AngryGhastlingFriendlyVariantEntity.this.getTarget() != null && AngryGhastlingFriendlyVariantEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = AngryGhastlingFriendlyVariantEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                AngryGhastlingFriendlyVariantEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 10.0);
            }

            public void tick() {
                LivingEntity livingentity = AngryGhastlingFriendlyVariantEntity.this.getTarget();
                if (AngryGhastlingFriendlyVariantEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    AngryGhastlingFriendlyVariantEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = AngryGhastlingFriendlyVariantEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        AngryGhastlingFriendlyVariantEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 10.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 3.0, 20){

            protected Vec3 getPosition() {
                RandomSource random = AngryGhastlingFriendlyVariantEntity.this.getRandom();
                double dir_x = AngryGhastlingFriendlyVariantEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = AngryGhastlingFriendlyVariantEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = AngryGhastlingFriendlyVariantEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 10.0, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataliving_sound_timer", ((Integer)this.entityData.get(DATA_living_sound_timer)).intValue());
        compound.putInt("Dataspeed_mul", ((Integer)this.entityData.get(DATA_speed_mul)).intValue());
        compound.putInt("Dataspeed_i", ((Integer)this.entityData.get(DATA_speed_i)).intValue());
        compound.putInt("Datadespawn_timer", ((Integer)this.entityData.get(DATA_despawn_timer)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataliving_sound_timer")) {
            this.entityData.set(DATA_living_sound_timer, (Object)compound.getInt("Dataliving_sound_timer"));
        }
        if (compound.contains("Dataspeed_mul")) {
            this.entityData.set(DATA_speed_mul, (Object)compound.getInt("Dataspeed_mul"));
        }
        if (compound.contains("Dataspeed_i")) {
            this.entityData.set(DATA_speed_i, (Object)compound.getInt("Dataspeed_i"));
        }
        if (compound.contains("Datadespawn_timer")) {
            this.entityData.set(DATA_despawn_timer, (Object)compound.getInt("Datadespawn_timer"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        AngryGhastlingFriendlyVariantOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(0.9f);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 25.0);
        builder = builder.add(Attributes.ARMOR, 3.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 48.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }
}

