/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.theangryghast.entity.AngrierGhastEntity;
import net.theangryghast.entity.AngriestGhastEntity;
import net.theangryghast.entity.AngriestGhastLootEyeEntity;
import net.theangryghast.entity.AngryGhastEntity;
import net.theangryghast.entity.AngryGhastlingEntity;
import net.theangryghast.entity.AngryGhastlingFriendlyVariantEntity;
import net.theangryghast.entity.EternalSnowballProjectileEntity;
import net.theangryghast.entity.NetherfishEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheAngryGhastModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"the_angry_ghast");
    public static final DeferredHolder<EntityType<?>, EntityType<AngryGhastEntity>> ANGRY_GHAST = TheAngryGhastModEntities.register("angry_ghast", EntityType.Builder.of(AngryGhastEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<AngrierGhastEntity>> ANGRIER_GHAST = TheAngryGhastModEntities.register("angrier_ghast", EntityType.Builder.of(AngrierGhastEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<NetherfishEntity>> NETHERFISH = TheAngryGhastModEntities.register("netherfish", EntityType.Builder.of(NetherfishEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.4f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<AngriestGhastEntity>> ANGRIEST_GHAST = TheAngryGhastModEntities.register("angriest_ghast", EntityType.Builder.of(AngriestGhastEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<AngryGhastlingEntity>> ANGRY_GHASTLING = TheAngryGhastModEntities.register("angry_ghastling", EntityType.Builder.of(AngryGhastlingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<AngryGhastlingFriendlyVariantEntity>> ANGRY_GHASTLING_FRIENDLY_VARIANT = TheAngryGhastModEntities.register("angry_ghastling_friendly_variant", EntityType.Builder.of(AngryGhastlingFriendlyVariantEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<EternalSnowballProjectileEntity>> ETERNAL_SNOWBALL_PROJECTILE = TheAngryGhastModEntities.register("eternal_snowball_projectile", EntityType.Builder.of(EternalSnowballProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<AngriestGhastLootEyeEntity>> ANGRIEST_GHAST_LOOT_EYE = TheAngryGhastModEntities.register("angriest_ghast_loot_eye", EntityType.Builder.of(AngriestGhastLootEyeEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 0.7f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        AngryGhastEntity.init(event);
        AngrierGhastEntity.init(event);
        NetherfishEntity.init(event);
        AngriestGhastEntity.init(event);
        AngryGhastlingEntity.init(event);
        AngryGhastlingFriendlyVariantEntity.init(event);
        AngriestGhastLootEyeEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ANGRY_GHAST.get(), AngryGhastEntity.createAttributes().build());
        event.put((EntityType)ANGRIER_GHAST.get(), AngrierGhastEntity.createAttributes().build());
        event.put((EntityType)NETHERFISH.get(), NetherfishEntity.createAttributes().build());
        event.put((EntityType)ANGRIEST_GHAST.get(), AngriestGhastEntity.createAttributes().build());
        event.put((EntityType)ANGRY_GHASTLING.get(), AngryGhastlingEntity.createAttributes().build());
        event.put((EntityType)ANGRY_GHASTLING_FRIENDLY_VARIANT.get(), AngryGhastlingFriendlyVariantEntity.createAttributes().build());
        event.put((EntityType)ANGRIEST_GHAST_LOOT_EYE.get(), AngriestGhastLootEyeEntity.createAttributes().build());
    }
}

