/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.theangryghast.potion.AngryFlightMobEffect;
import net.theangryghast.procedures.AngryFlightEffectExpiresProcedure;

@EventBusSubscriber
public class TheAngryGhastModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_angry_ghast");
    public static final DeferredHolder<MobEffect, MobEffect> ANGRY_FLIGHT = REGISTRY.register("angry_flight", () -> new AngryFlightMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheAngryGhastModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheAngryGhastModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ANGRY_FLIGHT)) {
            AngryFlightEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }
}

