/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.theangryghast.init.TheAngryGhastModItems;
import net.theangryghast.procedures.AngryAxeDashProcedure;

public class AngryAxeItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 5127;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 16;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheAngryGhastModItems.CYAN_CRY_OF_HELP.get()), new ItemStack((ItemLike)TheAngryGhastModItems.RED_CRY_OF_HELP.get()), new ItemStack((ItemLike)TheAngryGhastModItems.PURPLE_CRY_OF_HELP.get()), new ItemStack((ItemLike)TheAngryGhastModItems.ANGRY_GHAST_TEAR.get()), new ItemStack((ItemLike)TheAngryGhastModItems.ANGRIER_GHAST_TEAR.get()), new ItemStack((ItemLike)TheAngryGhastModItems.ANGRIEST_GHAST_TEAR.get()), new ItemStack((ItemLike)TheAngryGhastModItems.INTERDIMENSIONAL_CRY_OF_HELP.get())});
        }
    };

    public AngryAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)12.0f, (float)-2.7f)).fireResistant());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        AngryAxeDashProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.angry_axe.description_0"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.angry_axe.description_1"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.angry_axe.description_2"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.angry_axe.description_3"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.angry_axe.description_4"));
    }
}

