/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.theangryghast.init.TheAngryGhastModItems;
import net.theangryghast.procedures.BladeOfFuryLivingEntityIsHitWithToolProcedure;

public class BladeOfFuryItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 3752;
        }

        public float getSpeed() {
            return 4.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)TheAngryGhastModItems.RED_CRY_OF_HELP.get()), new ItemStack((ItemLike)Items.NETHERITE_INGOT), new ItemStack((ItemLike)Items.BLAZE_ROD)});
        }
    };

    public BladeOfFuryItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)9.0f, (float)-2.3f)).fireResistant());
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        BladeOfFuryLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), (Entity)entity, (Entity)sourceentity);
        return retval;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.blade_of_fury.description_0"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.blade_of_fury.description_1"));
        list.add((Component)Component.translatable((String)"item.the_angry_ghast.blade_of_fury.description_2"));
    }
}

