/*
 * Decompiled with CFR 0.152.
 */
package net.theangryghast.network;

import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.theangryghast.TheAngryGhastMod;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class TheAngryGhastModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"the_angry_ghast");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static double angriest_ghast_range_after_already_targetted = 200.0;
    public static double angriest_ghast_max_fly_height = 250.0;
    public static double angriest_ghast_min_fly_height = -35.0;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheAngryGhastMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"the_angry_ghast", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean AG_is_too_high = false;
        public boolean AG_is_too_low = false;
        public double AG_high_timer = 100.0;
        public double AG_low_timer = 100.0;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("AG_is_too_high", this.AG_is_too_high);
            nbt.putBoolean("AG_is_too_low", this.AG_is_too_low);
            nbt.putDouble("AG_high_timer", this.AG_high_timer);
            nbt.putDouble("AG_low_timer", this.AG_low_timer);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.AG_is_too_high = nbt.getBoolean("AG_is_too_high");
            this.AG_is_too_low = nbt.getBoolean("AG_is_too_low");
            this.AG_high_timer = nbt.getDouble("AG_high_timer");
            this.AG_low_timer = nbt.getDouble("AG_low_timer");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            if (!event.isWasDeath()) {
                clone.AG_is_too_high = original.AG_is_too_high;
                clone.AG_is_too_low = original.AG_is_too_low;
                clone.AG_high_timer = original.AG_high_timer;
                clone.AG_low_timer = original.AG_low_timer;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }
    }
}

