/*
 * Decompiled with CFR 0.152.
 */
package me.tg.versionnotifier.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

@Environment(value=EnvType.CLIENT)
public class VersionnotifierClient
implements ClientModInitializer {
    private static final String KNOWN_VERSIONS_FILE = "known_versions.txt";
    private static final String VERSION_MANIFEST = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private class_310 client;

    public void onInitializeClient() {
        this.client = class_310.method_1551();
        new Thread(() -> this.checkForNewVersion(true)).start();
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> this.checkForNewVersion(false), 60L, 60L, TimeUnit.SECONDS);
    }

    private void checkForNewVersion(boolean isStartup) {
        try {
            JsonObject manifest = JsonParser.parseReader((Reader)new InputStreamReader(new URL(VERSION_MANIFEST).openStream())).getAsJsonObject();
            JsonArray versionsArray = manifest.getAsJsonArray("versions");
            ArrayList<String> latestVersions = new ArrayList<String>();
            for (JsonElement versionElement : versionsArray) {
                JsonObject versionObj = versionElement.getAsJsonObject();
                latestVersions.add(versionObj.get("id").getAsString());
            }
            Path file = Path.of(KNOWN_VERSIONS_FILE, new String[0]);
            boolean showToast = false;
            String newest = (String)latestVersions.get(0);
            if (!Files.exists(file, new LinkOption[0])) {
                Files.write(file, latestVersions, new OpenOption[0]);
            } else {
                List<String> known = Files.readAllLines(file);
                if (!known.contains(newest)) {
                    showToast = true;
                    Files.write(file, latestVersions, new OpenOption[0]);
                }
            }
            if (showToast && this.client != null) {
                String title = isStartup ? "A new version has been released while you were gone" : "A new version has been released";
                this.client.execute(() -> {
                    class_370 toast = new class_370(class_370.class_371.field_2219, class_2561.method_30163((String)title), class_2561.method_30163((String)newest));
                    this.client.method_1566().method_1999((class_368)toast);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

