/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.util.CastUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FabricCommonRegister<C>
implements CommonRegister<C> {
    private final class_2378<C> registry;
    private final String modid;
    private final Map<FabricRegistryEntry<C>, Supplier<? extends C>> entries;
    private final Set<RegistryEntry<C>> entriesView;
    private boolean registryFrozen;

    FabricCommonRegister(class_5321<? extends class_2378<C>> key, String modid) {
        this.registry = (class_2378)CastUtil.uncheckedCast(class_7923.field_41167.method_10223(key.method_29177()));
        this.modid = modid;
        this.entries = new LinkedHashMap<FabricRegistryEntry<C>, Supplier<? extends C>>();
        this.entriesView = Collections.unmodifiableSet(this.entries.keySet());
    }

    @Override
    public <E extends C> FabricRegistryEntry<E> register(String name, Function<class_2960, ? extends E> function) {
        return this.register(name, () -> function.apply(new class_2960(this.modid, name)));
    }

    @Override
    public <E extends C> FabricRegistryEntry<E> register(String name, Supplier<? extends E> supplier) {
        if (this.registryFrozen) {
            throw new IllegalArgumentException("Registry is already frozen");
        }
        class_2960 id = new class_2960(this.modid, name);
        class_5321 key = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)id);
        FabricRegistryEntry entry = new FabricRegistryEntry(id, (class_5321)CastUtil.uncheckedCast(key));
        if (this.entries.putIfAbsent((FabricRegistryEntry)CastUtil.uncheckedCast(entry), supplier) != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return entry;
    }

    @Override
    public void register() {
        SetupEvents.REGISTER.register(this::registerEntries);
    }

    private void registerEntries(class_5321<? extends class_2378<?>> eventKey) {
        if (eventKey.equals((Object)this.registry.method_30517())) {
            this.registryFrozen = true;
            for (Map.Entry<FabricRegistryEntry<C>, Supplier<C>> entry : this.entries.entrySet()) {
                FabricRegistryEntry<C> registryEntry = entry.getKey();
                class_2378.method_39197(this.registry, registryEntry.getKey(), entry.getValue().get());
                registryEntry.updateReference(this.registry);
            }
        }
    }

    @Override
    public String getModid() {
        return this.modid;
    }

    @Override
    public class_5321<? extends class_2378<C>> getRegistryKey() {
        return this.registry.method_30517();
    }

    @Override
    public Collection<RegistryEntry<C>> getEntries() {
        return this.entriesView;
    }

    public static class FabricRegistryEntry<E>
    implements RegistryEntry<E> {
        private final class_2960 id;
        private final class_5321<E> key;
        private E value;
        private class_6880<E> holder;

        FabricRegistryEntry(class_2960 id, class_5321<E> key) {
            this.id = id;
            this.key = key;
        }

        void updateReference(class_2378<E> registry) {
            this.value = registry.method_10223(this.id);
            this.holder = registry.method_40264(this.key).orElse(null);
        }

        @Override
        public E get() {
            Objects.requireNonNull(this.value, () -> "Registry entry not present: " + String.valueOf(this.id));
            return this.value;
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        public class_5321<E> getKey() {
            return this.key;
        }

        @Override
        public Optional<class_6880<E>> getHolder() {
            return Optional.ofNullable(this.holder);
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }
    }

    public static class Factory
    implements CommonRegister.Factory {
        @Override
        public <C> CommonRegister<C> create(class_5321<? extends class_2378<C>> key, String modid) {
            return new FabricCommonRegister(key, modid);
        }
    }
}

