/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.EnvironmentUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_1657;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3248;

public class FabricNetworkHandler
implements NetworkHandler {
    public static final String NOT_ON_CLIENT = "\u1f640\u1f640MissingVersion";
    private final String protocolVersion;
    private Predicate<String> clientAcceptedVersions;
    private Predicate<String> serverAcceptedVersions;
    private final class_2960 channel;
    private final Map<Class<?>, MessagePacket<?>> messages;

    FabricNetworkHandler(String protocolVersion, class_2960 channel) {
        this.protocolVersion = protocolVersion;
        this.clientAcceptedVersions = protocolVersion::equals;
        this.serverAcceptedVersions = protocolVersion::equals;
        this.channel = channel;
        this.messages = new HashMap();
        EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.registerLoginReceiver(this, channel));
        ServerLoginNetworking.registerGlobalReceiver((class_2960)channel, (server, packetListener, understood, buffer, synchronizer, responseSender) -> {
            if (!understood) {
                buffer = PacketByteBufs.create().method_10814(NOT_ON_CLIENT);
            }
            this.acceptProtocolVersion(buffer, this.serverAcceptedVersions, arg_0 -> ((class_3248)packetListener).method_14380(arg_0));
        });
        ServerLoginConnectionEvents.QUERY_START.register((packetListener, server, sender, synchronizer) -> sender.sendPacket(channel, PacketByteBufs.create().method_10814(protocolVersion)));
    }

    @Override
    public <M> void registerMessage(int index, Class<M> clazz, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkContext> messageConsumer, Optional<NetworkEnvironment> handlerEnvironment) {
        class_2960 location = this.channel.method_48331("/" + index);
        MessagePacket<M> oldPacket = this.messages.put(clazz, new MessagePacket<M>(location, encoder, handlerEnvironment));
        if (oldPacket != null) {
            throw new IllegalArgumentException("Packet class " + String.valueOf(clazz) + " was already registered");
        }
        if (this.validNetworkEnvironment(NetworkEnvironment.SERVER, handlerEnvironment)) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)location, (server, player, packetListener, byteBuf, responseSender) -> messageConsumer.accept(this.decodeMessage(decoder, byteBuf), new FabricNetworkContext(NetworkEnvironment.SERVER, (class_1657)player, (class_1255<?>)server)));
        }
        if (this.validNetworkEnvironment(NetworkEnvironment.CLIENT, handlerEnvironment)) {
            EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.registerReceiver(this, location, decoder, messageConsumer));
        }
    }

    @Override
    public <M> void sendToPlayer(class_3222 player, M message) {
        EncodedMessage encodedMessage = this.encodeMessage(message, NetworkEnvironment.CLIENT);
        ServerPlayNetworking.send((class_3222)player, (class_2960)encodedMessage.location, (class_2540)encodedMessage.byteBuf);
    }

    @Override
    public <M> void sendToServer(M message) {
        EnvironmentUtil.runWhen(Platform.Environment.CLIENT, () -> () -> Client.send(this, message));
    }

    @Override
    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void setProtocolAcceptor(Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions) {
        this.clientAcceptedVersions = clientAcceptedVersions;
        this.serverAcceptedVersions = serverAcceptedVersions;
    }

    private <M> EncodedMessage encodeMessage(M message, NetworkEnvironment expectedHandler) {
        MessagePacket packet = (MessagePacket)CastUtil.uncheckedCast(this.messages.get(message.getClass()));
        if (packet == null) {
            throw new IllegalArgumentException("Message " + String.valueOf(message.getClass()) + " was not registred");
        }
        if (!this.validNetworkEnvironment(expectedHandler, packet.handlerEnvironment)) {
            throw new IllegalArgumentException("Message " + String.valueOf(message.getClass()) + " cannot be used to send to " + String.valueOf((Object)expectedHandler));
        }
        class_2540 buffer = PacketByteBufs.create();
        packet.encoder.accept(message, buffer);
        return new EncodedMessage(packet.location, buffer);
    }

    private <M> M decodeMessage(Function<class_2540, M> decoder, class_2540 buffer) {
        return decoder.apply(buffer);
    }

    private boolean validNetworkEnvironment(NetworkEnvironment expected, Optional<NetworkEnvironment> handlerEnvironment) {
        NetworkEnvironment environment = handlerEnvironment.orElse(null);
        return environment == null || environment == expected;
    }

    private boolean acceptProtocolVersion(class_2540 buffer, Predicate<String> predicate, Consumer<class_2561> disconnectMessage) {
        String receivedProtocolVersion = buffer.method_19772();
        if (!predicate.test(receivedProtocolVersion)) {
            disconnectMessage.accept((class_2561)class_2561.method_43470((String)("Protocol version for channel " + String.valueOf(this.channel) + " does not match. Expected: " + this.protocolVersion + ", received: " + receivedProtocolVersion)));
            return false;
        }
        return true;
    }

    private record MessagePacket<M>(class_2960 location, BiConsumer<M, class_2540> encoder, Optional<NetworkEnvironment> handlerEnvironment) {
    }

    private record EncodedMessage(class_2960 location, class_2540 byteBuf) {
    }

    private static class Client {
        private Client() {
        }

        public static void registerLoginReceiver(FabricNetworkHandler handler, class_2960 location) {
            ClientLoginNetworking.registerGlobalReceiver((class_2960)location, (client, packetListener, buffer, listenerAdder) -> {
                if (handler.acceptProtocolVersion(buffer, handler.clientAcceptedVersions, arg_0 -> ((class_2535)packetListener.field_3707).method_10747(arg_0))) {
                    return CompletableFuture.completedFuture(PacketByteBufs.create().method_10814(handler.protocolVersion));
                }
                return CompletableFuture.completedFuture(null);
            });
        }

        public static <M> void send(FabricNetworkHandler handler, M message) {
            EncodedMessage encodedMessage = handler.encodeMessage(message, NetworkEnvironment.SERVER);
            ClientPlayNetworking.send((class_2960)encodedMessage.location, (class_2540)encodedMessage.byteBuf);
        }

        public static <M> void registerReceiver(FabricNetworkHandler handler, class_2960 location, Function<class_2540, M> decoder, BiConsumer<M, NetworkContext> messageConsumer) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)location, (client, packetListener, byteBuf, responseSender) -> messageConsumer.accept(handler.decodeMessage(decoder, byteBuf), new FabricNetworkContext(NetworkEnvironment.CLIENT, (class_1657)client.field_1724, (class_1255<?>)client)));
        }
    }

    public static class FabricNetworkContext
    implements NetworkContext {
        private final NetworkEnvironment environment;
        private final class_1657 player;
        private final class_1255<?> executor;

        FabricNetworkContext(NetworkEnvironment environment, class_1657 player, class_1255<?> executor) {
            this.environment = environment;
            this.player = player;
            this.executor = executor;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return this.environment;
        }

        @Override
        public class_1657 getPlayer() {
            return this.player;
        }

        @Override
        public void executeOnMainThread(Runnable runnable) {
            if (!this.executor.method_18854()) {
                this.executor.method_5382(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(String protocolVersion, class_2960 location) {
            return new FabricNetworkHandler(protocolVersion, location);
        }
    }
}

