/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public abstract class CommonGlobalLootModifierProvider
implements DataProvider,
CommonDataProvider<BiConsumer<String, ? super IGlobalLootModifier>> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final GenerationData generationData;
    private final PackOutput.PathProvider pathProvider;
    protected boolean replace;

    public CommonGlobalLootModifierProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.pathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "loot_modifiers");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        TreeMap serializers = new TreeMap();
        this.register((modifier, instance) -> serializers.put(modifier, instance));
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        List entries = serializers.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            ResourceLocation location = new ResourceLocation(this.modid(), name);
            futures.add(this.saveData(cache, IGlobalLootModifier.DIRECT_CODEC, (IGlobalLootModifier)entry.getValue(), this.pathProvider.json(location)));
            return location;
        }).map(ResourceLocation::toString).collect(Collectors.toList());
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(this.replace));
        json.add("entries", GSON.toJsonTree(entries));
        futures.add(this.saveData(cache, (JsonElement)json, this.pathProvider.json(new ResourceLocation("forge", "global_loot_modifiers"))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected void replacing() {
        this.replace = true;
    }

    public String getName() {
        return "Global-Loot-Modifier: " + this.nameSuffix();
    }
}

