/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public abstract class CommonLanguagesProvider
implements DataProvider,
CommonDataProvider.NoParam {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String DEFAULT_LANG = "en_us";
    private final GenerationData generationData;
    private final Map<String, Map<String, String>> data;
    private final PackOutput.PathProvider pathProvider;

    public CommonLanguagesProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.data = new HashMap<String, Map<String, String>>();
        this.pathProvider = generationData.output().createPathProvider(PackOutput.Target.RESOURCE_PACK, "lang");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.register(null);
        return CompletableFuture.allOf((CompletableFuture[])this.data.entrySet().stream().filter(entry -> !((Map)entry.getValue()).isEmpty()).map(entry -> {
            String locale = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            return this.saveData(cache, GSON.toJsonTree((Object)map), this.pathProvider.json(new ResourceLocation(this.modid(), locale)));
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Languages: " + this.nameSuffix();
    }

    protected void add(CreativeModeTab key, String name) {
        Component component = key.getDisplayName();
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            this.add(translatableContents.getKey(), name);
        }
    }

    protected void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addItemStack(Supplier<? extends ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(MobEffect key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void add(Supplier<? extends Fluid> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Fluid key, String name) {
        this.add(key.getFluidType().getDescriptionId(), name);
    }

    protected void add(String key, String value) {
        this.add(DEFAULT_LANG, key, value);
    }

    protected void add(String locale, CreativeModeTab key, String name) {
        Component component = key.getDisplayName();
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            this.add(locale, translatableContents.getKey(), name);
        }
    }

    protected void addBlock(String locale, Supplier<? extends Block> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Block key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addItem(String locale, Supplier<? extends Item> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Item key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addItemStack(String locale, Supplier<? extends ItemStack> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, ItemStack key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addEnchantment(String locale, Supplier<? extends Enchantment> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Enchantment key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addEffect(String locale, Supplier<? extends MobEffect> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, MobEffect key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addEntityType(String locale, Supplier<? extends EntityType<?>> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, EntityType<?> key, String name) {
        this.add(locale, key.getDescriptionId(), name);
    }

    protected void addFluid(String locale, Supplier<? extends Fluid> key, String name) {
        this.add(locale, key.get(), name);
    }

    protected void add(String locale, Fluid key, String name) {
        this.add(locale, key.getFluidType().getDescriptionId(), name);
    }

    protected void add(String locale, String key, String value) {
        Map map = this.data.computeIfAbsent(locale, unused -> new TreeMap());
        if (map.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    protected void addBlockTooltip(Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(() -> ((Block)key.get()).asItem(), category, line, value);
    }

    protected void addBlockTooltip(String locale, Supplier<? extends Block> key, String category, int line, String value) {
        this.addItemTooltip(locale, () -> ((Block)key.get()).asItem(), category, line, value);
    }

    protected void addItemTooltip(Supplier<? extends Item> key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(key.get().getDescriptionId() + ".tooltip." + (String)category + line, value);
    }

    protected void addItemTooltip(String locale, Supplier<? extends Item> key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(locale, key.get().getDescriptionId() + ".tooltip." + (String)category + line, value);
    }

    protected void addTooltip(String key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add("general." + this.modid() + "." + key + ".tooltip." + (String)category + line, value);
    }

    protected void addTooltip(String locale, String key, String category, int line, String value) {
        if (!((String)category).isEmpty()) {
            category = (String)category + ".";
        }
        this.add(locale, "general." + this.modid() + "." + key + ".tooltip." + (String)category + line, value);
    }
}

