/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.intern.loot_item_function.SetBlockEntityNBTLootItemFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CommonLootTableProvider
implements DataProvider,
CommonDataProvider<BiConsumer<ResourceLocation, LootTable>> {
    private final GenerationData generationData;
    private final PackOutput.PathProvider pathProvider;

    public CommonLootTableProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.pathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "loot_tables");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList futures = new ArrayList();
        this.register((location, lootTable) -> futures.add(this.saveData(cache, LootTable.DIRECT_CODEC, lootTable, this.pathProvider.json(location))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Loot-Table: " + this.nameSuffix();
    }

    protected static void registerBlock(Supplier<? extends Block> supplier, LootTable.Builder builder, BiConsumer<ResourceLocation, LootTable> consumer) {
        CommonLootTableProvider.registerBlock(supplier.get(), builder, consumer);
    }

    protected static void registerBlock(Block block, LootTable.Builder builder, BiConsumer<ResourceLocation, LootTable> consumer) {
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)block).withPrefix("blocks/");
        consumer.accept(location, builder.setRandomSequence(location).build());
    }

    protected static LootTable.Builder addBasicBlockLootTable(ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).when(ExplosionCondition.survivesExplosion()));
    }

    protected static LootTable.Builder addBlockEntityBlockLootTable(ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply(SetBlockEntityNBTLootItemFunction.builder()).when(ExplosionCondition.survivesExplosion()));
    }

    protected static LootTable.Builder addFortuneBlockLootTable(Block block, ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate(Enchantments.SILK_TOUCH, MinMaxBounds.Ints.atLeast((int)1)))))))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Enchantment)Enchantments.FORTUNE)).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))));
    }
}

