/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public abstract class CommonRecipeProvider
implements DataProvider,
CommonDataProvider<RecipeOutput> {
    private final GenerationData generationData;
    private final PackOutput.PathProvider recipePathProvider;
    private final PackOutput.PathProvider advancementPathProvider;

    public CommonRecipeProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.recipePathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "advancements");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(final CachedOutput cache) {
        return this.getGenerationData().registriesFuture().thenCompose(registries -> {
            final HashSet duplicates = Sets.newHashSet();
            ArrayList futures = new ArrayList();
            Function<Boolean, RecipeOutput> recipeOutputCreator = vanillaAdvancements -> new RecipeOutput(){
                final /* synthetic */ Boolean val$vanillaAdvancements;
                final /* synthetic */ List val$futures;
                final /* synthetic */ HolderLookup.Provider val$registries;
                {
                    this.val$vanillaAdvancements = bl;
                    this.val$futures = list;
                    this.val$registries = provider;
                }

                public Advancement.Builder advancement() {
                    return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
                }

                public void accept(ResourceLocation id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement) {
                    CommonRecipeProvider.this.generateRecipe(cache, id, recipe, advancementId, advancement, duplicates, this.val$vanillaAdvancements, this.val$futures);
                }

                public HolderLookup.Provider registry() {
                    return this.val$registries;
                }
            };
            this.register(recipeOutputCreator.apply(false));
            this.registerVanilla(recipeOutputCreator.apply(true));
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Recipe: " + this.nameSuffix();
    }

    public void registerVanilla(RecipeOutput consumer) {
    }

    private void generateRecipe(CachedOutput cache, ResourceLocation id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement, Set<ResourceLocation> duplicates, boolean vanillaAdvancements, List<CompletableFuture<?>> futures) {
        if (!duplicates.add(id)) {
            throw new IllegalStateException("Duplicate recipe " + String.valueOf(id));
        }
        futures.add(this.saveData(cache, Recipe.CODEC, recipe, this.recipePathProvider.json(id)));
        if (advancement != null) {
            ResourceLocation advancementLocation = vanillaAdvancements ? advancementId : new ResourceLocation(id.getNamespace(), "recipes/" + id.getPath());
            futures.add(this.saveData(cache, advancement, this.advancementPathProvider.json(advancementLocation)));
        }
    }

    protected Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> tag) {
        return this.has(ItemPredicate.Builder.item().of(tag).build());
    }

    protected Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike item) {
        return this.has(ItemPredicate.Builder.item().of(new ItemLike[]{item}).build());
    }

    protected Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }
}

