/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.energy;

import info.u_team.u_team_core.api.sync.DataHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.EnergyStorage;

public class BasicEnergyStorage
extends EnergyStorage {
    public BasicEnergyStorage(int capacity) {
        this(capacity, capacity, capacity, 0);
    }

    public BasicEnergyStorage(int capacity, int maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0);
    }

    public BasicEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        this(capacity, maxReceive, maxExtract, 0);
    }

    public BasicEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int value = super.extractEnergy(maxExtract, simulate);
        if (!simulate) {
            this.onEnergyChanged();
        }
        return value;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int value = super.receiveEnergy(maxReceive, simulate);
        if (!simulate) {
            this.onEnergyChanged();
        }
        return value;
    }

    public int getEnergy() {
        return super.getEnergyStored();
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public void addEnergy(int energy) {
        this.energy += energy;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getMaxEnergyStored();
        } else if (this.energy < 0) {
            this.energy = 0;
        }
        this.onEnergyChanged();
    }

    public void removeEnergy(int energy) {
        this.addEnergy(-energy);
    }

    public void onEnergyChanged() {
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putInt("energy", this.getEnergyStored());
        return compound;
    }

    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.setEnergy(compoundTag.getInt("energy"));
        } else {
            super.deserializeNBT(tag);
        }
    }

    public DataHolder createSyncHandler() {
        return DataHolder.createIntHolder(this::getEnergy, this::setEnergy);
    }
}

