/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.event.ClientEvents;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;

public class ForgeClientEventsHandler
implements ClientEvents.Handler {
    @Override
    public void registerStartClientTick(ClientEvents.StartClientTick event) {
        this.registerForgeEvent(TickEvent.ClientTickEvent.Pre.class, forgeEvent -> event.onStartTick(Minecraft.getInstance()));
    }

    @Override
    public void registerEndClientTick(ClientEvents.EndClientTick event) {
        this.registerForgeEvent(TickEvent.ClientTickEvent.Post.class, forgeEvent -> event.onEndTick(Minecraft.getInstance()));
    }

    @Override
    public void registerStartClientLevelTick(ClientEvents.StartClientLevelTick event) {
        this.registerForgeEvent(TickEvent.LevelTickEvent.Pre.class, forgeEvent -> {
            Level patt0$temp = forgeEvent.level;
            if (patt0$temp instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)patt0$temp;
                event.onStartTick(clientLevel);
            }
        });
    }

    @Override
    public void registerEndClientLevelTick(ClientEvents.EndClientLevelTick event) {
        this.registerForgeEvent(TickEvent.LevelTickEvent.Post.class, forgeEvent -> {
            Level patt0$temp = forgeEvent.level;
            if (patt0$temp instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)patt0$temp;
                event.onEndTick(clientLevel);
            }
        });
    }

    @Override
    public void registerScreenAfterKeyPressed(ClientEvents.ScreenAfterKeyPressed event) {
        this.registerForgeEvent(ScreenEvent.KeyPressed.Post.class, forgeEvent -> {
            if (event.onKeyPressed(forgeEvent.getScreen(), forgeEvent.getKeyCode(), forgeEvent.getScanCode(), forgeEvent.getModifiers())) {
                forgeEvent.setCanceled(true);
            }
        });
    }

    @Override
    public void registerItemTooltip(ClientEvents.ItemTooltip event) {
        this.registerForgeEvent(ItemTooltipEvent.class, forgeEvent -> event.onTooltip(forgeEvent.getItemStack(), forgeEvent.getFlags(), forgeEvent.getToolTip()));
    }

    private <T extends Event> void registerForgeEvent(Class<T> eventClass, Consumer<T> event) {
        BusRegister.registerForge(bus -> bus.addListener(EventPriority.NORMAL, false, eventClass, event));
    }
}

