/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.loot_item_function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import info.u_team.u_team_core.intern.init.UCoreLootItemFunctions;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBlockEntityNBTLootItemFunction
extends LootItemConditionalFunction {
    public static final MapCodec<SetBlockEntityNBTLootItemFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetBlockEntityNBTLootItemFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SetBlockEntityNBTLootItemFunction::new));

    public static LootItemConditionalFunction.Builder<?> builder() {
        return SetBlockEntityNBTLootItemFunction.simpleBuilder(SetBlockEntityNBTLootItemFunction::new);
    }

    private SetBlockEntityNBTLootItemFunction(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (context.hasParam(LootContextParams.BLOCK_ENTITY)) {
            BlockEntity blockEntity = (BlockEntity)context.getParam(LootContextParams.BLOCK_ENTITY);
            blockEntity.saveToItem(stack, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
        }
        return stack;
    }

    public LootItemFunctionType<SetBlockEntityNBTLootItemFunction> getType() {
        return (LootItemFunctionType)UCoreLootItemFunctions.SET_BLOCKENTITY_NBT.get();
    }
}

