/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.inventory;

import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class CraftingRecipeWrapper
extends TransientCraftingContainer {
    protected final IItemHandlerModifiable inventory;

    public CraftingRecipeWrapper(IItemHandlerModifiable inventory, int width, int height) {
        super(null, width, height);
        this.inventory = inventory;
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (this.inventory.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(slot);
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.setItem(slot, ItemStack.EMPTY);
        return stack;
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        return stack.isEmpty() ? ItemStack.EMPTY : stack.split(count);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public void clearContent() {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            this.inventory.setStackInSlot(slot, ItemStack.EMPTY);
        }
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.inventory.isItemValid(slot, stack);
    }

    public void fillStackedContents(StackedContents helper) {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            helper.accountSimpleStack(this.inventory.getStackInSlot(slot));
        }
    }
}

