/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import info.u_team.u_team_core.gui.renderer.FluidInventoryRenderer;
import info.u_team.u_team_core.intern.init.UCoreForgeNetwork;
import info.u_team.u_team_core.intern.network.FluidClickContainerMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.FluidSlot;
import info.u_team.u_team_core.menu.ForgeFluidContainerMenuDelegator;
import info.u_team.u_team_core.screen.FluidContainerMenuScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeFluidContainerMenuScreenDelegator<T extends AbstractContainerMenu>
implements FluidContainerMenuScreen.FluidContainerScreenDelegator {
    private final FluidContainerMenuScreen<T> screen;
    protected FluidInventoryRenderer fluidRenderer = FluidInventoryRenderer.DEFAULT_INSTANCE;
    protected FluidSlot hoveredFluidSlot;

    ForgeFluidContainerMenuScreenDelegator(FluidContainerMenuScreen<T> screen) {
        this.screen = screen;
    }

    public void setFluidRenderer(FluidInventoryRenderer fluidRenderer) {
        this.fluidRenderer = fluidRenderer;
    }

    @Override
    public void renderLabels(GuiGraphics guiGrapics, int mouseX, int mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.screen.getMenu();
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            this.hoveredFluidSlot = null;
            for (int slot = 0; slot < ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots.size(); ++slot) {
                FluidSlot fluidSlot = ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots.get(slot);
                if (!fluidSlot.isActive()) continue;
                this.renderFluidSlot(guiGrapics, fluidSlot);
                if (!this.isHovering(fluidSlot, mouseX, mouseY)) continue;
                this.hoveredFluidSlot = fluidSlot;
                RenderUtil.setShaderColor(RGBA.WHITE);
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGrapics, (int)fluidSlot.getX(), (int)fluidSlot.getY(), (int)0, (int)this.getFluidSlotColor(slot));
            }
        }
    }

    protected void renderFluidSlot(GuiGraphics guiGrapics, FluidSlot fluidSlot) {
        Pair<ResourceLocation, ResourceLocation> pair;
        PoseStack poseStack = guiGrapics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        int x = fluidSlot.getX();
        int y = fluidSlot.getY();
        if (!fluidSlot.hasFluid() && fluidSlot.isActive() && (pair = fluidSlot.getNoItemIcon()) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)this.screen.getMinecraft().getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
            RenderUtil.drawTexturedQuad(poseStack, x, y, 16, 16, 0.0f, sprite, RGBA.WHITE);
        }
        this.fluidRenderer.drawFluidInSlot(poseStack, x, y, 0.0f, fluidSlot.getFluid());
        poseStack.popPose();
    }

    @Override
    public void renderTooltip(GuiGraphics guiGrapics, int mouseX, int mouseY) {
        if (this.screen.getMenu().getCarried().isEmpty() && this.hoveredFluidSlot != null && this.hoveredFluidSlot.hasFluid()) {
            guiGrapics.renderComponentTooltip(Minecraft.getInstance().font, this.getTooltipFromFluid(this.hoveredFluidSlot), mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        FluidSlot fluidSlot;
        if (button == 0 && (fluidSlot = this.findFluidSlot(mouseX, mouseY)) != null) {
            if (!this.screen.getMenu().getCarried().isEmpty()) {
                UCoreForgeNetwork.NETWORK.send((Object)new FluidClickContainerMessage(this.screen.getMenu().containerId, fluidSlot.index, Screen.hasShiftDown(), this.screen.getMenu().getCarried()), PacketDistributor.SERVER.noArg());
            }
            return true;
        }
        return false;
    }

    protected FluidSlot findFluidSlot(double mouseX, double mouseY) {
        AbstractContainerMenu abstractContainerMenu = this.screen.getMenu();
        if (abstractContainerMenu instanceof FluidContainerMenu) {
            FluidContainerMenu fluidMenu = (FluidContainerMenu)abstractContainerMenu;
            for (FluidSlot fluidSlot : ((ForgeFluidContainerMenuDelegator)fluidMenu.getDelegator()).fluidSlots) {
                if (!this.isHovering(fluidSlot, mouseX, mouseY) || !fluidSlot.isActive()) continue;
                return fluidSlot;
            }
        }
        return null;
    }

    protected boolean isHovering(FluidSlot fluidSlot, double mouseX, double mouseY) {
        return this.screen.isHovering(fluidSlot.getX(), fluidSlot.getY(), 16, 16, mouseX, mouseY);
    }

    protected int getFluidSlotColor(int index) {
        return this.screen.getSlotColor(index);
    }

    public List<Component> getTooltipFromFluid(FluidSlot fluidSlot) {
        FluidStack stack = fluidSlot.getFluid();
        ArrayList<Component> list = new ArrayList<Component>();
        list.add(stack.getDisplayName());
        list.add((Component)Component.literal((String)(stack.getAmount() + " mb/" + fluidSlot.getSlotCapacity() + " mb")).withStyle(ChatFormatting.GRAY));
        if (this.screen.getMinecraft().options.advancedItemTooltips) {
            list.add((Component)Component.literal((String)ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return list;
    }

    public static class Factory
    implements FluidContainerMenuScreen.FluidContainerScreenDelegator.Factory {
        @Override
        public <T extends AbstractContainerMenu> FluidContainerMenuScreen.FluidContainerScreenDelegator create(FluidContainerMenuScreen<T> menu) {
            return new ForgeFluidContainerMenuScreenDelegator<T>(menu);
        }
    }
}

