/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import info.u_team.u_team_core.util.RGB;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ColorUtil {
    private static final BiMap<Block, DyeColor> WOOL_DYE_COLORS = HashBiMap.create();
    public static final int WHITE_RGBA = -1;
    public static final int WHITE_RGB = 0xFFFFFF;

    public static Block getWoolFromColor(DyeColor color) {
        return (Block)WOOL_DYE_COLORS.inverse().get((Object)color);
    }

    public static DyeColor getColorFromWool(Item item) {
        return ColorUtil.getColorFromWool(Block.byItem((Item)item));
    }

    public static DyeColor getColorFromWool(Block block) {
        return (DyeColor)WOOL_DYE_COLORS.get((Object)block);
    }

    public static DyeColor findClosestDyeColor(RGB rgb) {
        DyeColor match = DyeColor.WHITE;
        double clostestMatch = Double.MAX_VALUE;
        for (DyeColor color : DyeColor.values()) {
            float[] textureColor = color.getTextureDiffuseColors();
            double difference = Math.pow(textureColor[0] - rgb.getRedComponent(), 2.0) + Math.pow(textureColor[1] - rgb.getGreenComponent(), 2.0) + Math.pow(textureColor[2] - rgb.getBlueComponent(), 2.0);
            if (!(difference < clostestMatch)) continue;
            clostestMatch = difference;
            match = color;
        }
        return match;
    }

    static {
        WOOL_DYE_COLORS.put((Object)Blocks.WHITE_WOOL, (Object)DyeColor.WHITE);
        WOOL_DYE_COLORS.put((Object)Blocks.ORANGE_WOOL, (Object)DyeColor.ORANGE);
        WOOL_DYE_COLORS.put((Object)Blocks.MAGENTA_WOOL, (Object)DyeColor.MAGENTA);
        WOOL_DYE_COLORS.put((Object)Blocks.LIGHT_BLUE_WOOL, (Object)DyeColor.LIGHT_BLUE);
        WOOL_DYE_COLORS.put((Object)Blocks.YELLOW_WOOL, (Object)DyeColor.YELLOW);
        WOOL_DYE_COLORS.put((Object)Blocks.LIME_WOOL, (Object)DyeColor.LIME);
        WOOL_DYE_COLORS.put((Object)Blocks.PINK_WOOL, (Object)DyeColor.PINK);
        WOOL_DYE_COLORS.put((Object)Blocks.GRAY_WOOL, (Object)DyeColor.GRAY);
        WOOL_DYE_COLORS.put((Object)Blocks.LIGHT_GRAY_WOOL, (Object)DyeColor.LIGHT_GRAY);
        WOOL_DYE_COLORS.put((Object)Blocks.CYAN_WOOL, (Object)DyeColor.CYAN);
        WOOL_DYE_COLORS.put((Object)Blocks.PURPLE_WOOL, (Object)DyeColor.PURPLE);
        WOOL_DYE_COLORS.put((Object)Blocks.BLUE_WOOL, (Object)DyeColor.BLUE);
        WOOL_DYE_COLORS.put((Object)Blocks.BROWN_WOOL, (Object)DyeColor.BROWN);
        WOOL_DYE_COLORS.put((Object)Blocks.GREEN_WOOL, (Object)DyeColor.GREEN);
        WOOL_DYE_COLORS.put((Object)Blocks.RED_WOOL, (Object)DyeColor.RED);
        WOOL_DYE_COLORS.put((Object)Blocks.BLACK_WOOL, (Object)DyeColor.BLACK);
    }
}

