/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.google.gson.JsonElement;
import info.u_team.u_team_core.ingredient.FluidIngredient;
import info.u_team.u_team_core.util.RegistryUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class SerializeUtil {
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Fluid>> FLUID_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.FLUID);
    public static StreamCodec<RegistryFriendlyByteBuf, FluidStack> FLUID_STACK_STREAM_CODEC = StreamCodec.of((buffer, stack) -> {
        if (stack.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            FLUID_STREAM_CODEC.encode(buffer, (Object)RegistryUtil.getBuiltInRegistry(Registries.FLUID).wrapAsHolder((Object)stack.getFluid()));
            buffer.writeVarInt(stack.getAmount());
            buffer.writeNbt((Tag)stack.getTag());
        }
    }, buffer -> {
        if (buffer.readBoolean()) {
            Fluid stackFluid = (Fluid)((Holder)FLUID_STREAM_CODEC.decode(buffer)).get();
            int stackAmount = buffer.readVarInt();
            CompoundTag tag = buffer.readNbt();
            return new FluidStack(stackFluid, stackAmount, tag);
        }
        return FluidStack.EMPTY;
    });

    public static JsonElement serializeFluidIngredient(FluidIngredient ingredient) {
        return ingredient.serialize();
    }

    public static FluidIngredient deserializeFluidIngredient(JsonElement json) {
        return FluidIngredient.deserialize(json);
    }
}

