/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.io.IOException;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class CommonBlockStatesProvider
extends BlockStateProvider {
    protected final Marker marker;
    protected final GenerationData data;
    protected final String modid;
    protected final DataGenerator generator;

    public CommonBlockStatesProvider(GenerationData data) {
        super(data.getGenerator(), data.getModid(), data.getExistingFileHelper());
        this.data = data;
        this.modid = data.getModid();
        this.generator = data.getGenerator();
        this.marker = MarkerManager.getMarker((String)this.m_6055_());
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.models().generatedModels.clear();
        this.registerModels0(cache);
        this.models().generatedModels.values().forEach(model -> {
            try {
                ResourceLocation location = model.getLocation();
                CommonProvider.write(cache, (JsonElement)model.toJson(), this.generator.m_123916_().resolve("assets/" + location.m_135827_() + "/models/" + location.m_135815_() + ".json"));
            }
            catch (IOException ex) {
                CommonProvider.LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    private void registerModels0(HashCache cache) {
        this.registeredBlocks.clear();
        this.registerStatesAndModels();
        this.registeredBlocks.forEach((block, generatedState) -> {
            try {
                ResourceLocation location = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName());
                CommonProvider.write(cache, (JsonElement)generatedState.toJson(), this.generator.m_123916_().resolve("assets/" + location.m_135827_() + "/blockstates/" + location.m_135815_() + ".json"));
            }
            catch (IOException ex) {
                CommonProvider.LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    public String m_6055_() {
        return "Block-States | Block-Models";
    }

    protected void facingBlock(Block block, ModelFile modelFile) {
        this.facingBlock(block, modelFile, 0);
    }

    protected void facingBlock(Block block, ModelFile modelFile, int angleOffset) {
        this.facingBlock(block, (BlockState $) -> modelFile, angleOffset);
    }

    protected void facingBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(direction == Direction.DOWN ? 90 : (direction == Direction.UP ? 270 : 0)).rotationY(direction.m_122434_().m_122478_() ? 0 : ((int)direction.m_122435_() + angleOffset + 180) % 360).build();
        });
    }

    protected BlockModelBuilder cubeFacing(String name, ResourceLocation front, ResourceLocation side) {
        return this.cubeFacing(name, front, side, side);
    }

    protected BlockModelBuilder cubeFacing(String name, ResourceLocation front, ResourceLocation side, ResourceLocation particle) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("uteamcore", "block/facing")))).texture("particle", particle)).texture("front", front)).texture("side", side);
    }

    protected BlockModelBuilder cubeFacingBottomTop(String name, ResourceLocation front, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.cubeFacingBottomTop(name, front, bottom, top, side, side);
    }

    protected BlockModelBuilder cubeFacingBottomTop(String name, ResourceLocation front, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation particle) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("uteamcore", "block/facing_bottom_top")))).texture("particle", particle)).texture("front", front)).texture("bottom", bottom)).texture("top", top)).texture("side", side);
    }

    protected String getPath(Block block) {
        return block.getRegistryName().m_135815_();
    }
}

