/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.intern.loot.SetBlockEntityNBTLootFunction;
import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class CommonLootTablesProvider
extends CommonProvider {
    public CommonLootTablesProvider(GenerationData data) {
        super(data);
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.registerLootTables((location, lootTable) -> {
            try {
                CommonLootTablesProvider.write(cache, LootTables.m_79200_((LootTable)lootTable), this.resolveData((ResourceLocation)location).resolve("loot_tables").resolve(location.m_135815_() + ".json"));
            }
            catch (IOException ex) {
                LOGGER.error(this.marker, "Could not write data.", (Throwable)ex);
            }
        });
    }

    protected abstract void registerLootTables(BiConsumer<ResourceLocation, LootTable> var1);

    public String m_6055_() {
        return "Loot-Tables";
    }

    protected static void registerBlock(Supplier<? extends Block> supplier, LootTable lootTable, BiConsumer<ResourceLocation, LootTable> consumer) {
        CommonLootTablesProvider.registerBlock(supplier.get(), lootTable, consumer);
    }

    protected static void registerBlock(Block block, LootTable lootTable, BiConsumer<ResourceLocation, LootTable> consumer) {
        ResourceLocation registryName = block.getRegistryName();
        consumer.accept(new ResourceLocation(registryName.m_135827_(), "blocks/" + registryName.m_135815_()), lootTable);
    }

    protected static LootTable addBasicBlockLootTable(ItemLike item) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)).m_6509_(ExplosionCondition.m_81661_())).m_79167_();
    }

    protected static LootTable addTileEntityBlockLootTable(ItemLike item) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item)).m_5577_(SetBlockEntityNBTLootFunction.builder()).m_6509_(ExplosionCondition.m_81661_())).m_79167_();
    }

    protected static LootTable addFortuneBlockLootTable(Block block, ItemLike item) {
        return LootTable.m_79147_().m_79165_(LootContextParamSets.f_81421_).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1)))))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())))).m_79167_();
    }
}

