/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import info.u_team.u_team_core.api.fluid.FluidHandlerModifiable;
import info.u_team.u_team_core.api.menu.FluidContainerListener;
import info.u_team.u_team_core.intern.init.UCoreNetwork;
import info.u_team.u_team_core.intern.network.ContainerSetFluidContentMessage;
import info.u_team.u_team_core.intern.network.ContainerSetFluidSlotMessage;
import info.u_team.u_team_core.menu.FluidSlot;
import info.u_team.u_team_core.menu.UAbstractContainerMenu;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.PacketDistributor;

public abstract class FluidContainerMenu
extends UAbstractContainerMenu {
    private final NonNullList<FluidStack> lastFluidSlots = NonNullList.m_122779_();
    public final List<FluidSlot> fluidSlots = NonNullList.m_122779_();
    private final NonNullList<FluidStack> remoteFluidSlots = NonNullList.m_122779_();

    protected FluidContainerMenu(MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    protected FluidSlot addFluidSlot(FluidSlot slot) {
        slot.index = this.fluidSlots.size();
        this.fluidSlots.add(slot);
        this.lastFluidSlots.add((Object)FluidStack.EMPTY);
        this.remoteFluidSlots.add((Object)FluidStack.EMPTY);
        return slot;
    }

    public FluidSlot getFluidSlot(int slotId) {
        return this.fluidSlots.get(slotId);
    }

    public void fluidSlotClick(ServerPlayer player, int index, boolean shift, ItemStack clientClickStack) {
        int maximumTries;
        ItemStack serverClickStack = this.m_142621_();
        if (serverClickStack.m_41619_() || !ItemStack.m_41728_((ItemStack)clientClickStack, (ItemStack)serverClickStack) || index < 0 && index >= this.fluidSlots.size()) {
            return;
        }
        FluidSlot fluidSlot = this.fluidSlots.get(index);
        Optional containedFluidOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)serverClickStack, (int)1)).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (!containedFluidOptional.isPresent()) {
            return;
        }
        int n = maximumTries = shift ? serverClickStack.m_41613_() : 1;
        if (!((FluidStack)containedFluidOptional.orElseThrow(AssertionError::new)).isEmpty()) {
            for (int i = 0; i < maximumTries && this.insertFluidFromItem(player, fluidSlot, shift); ++i) {
            }
        } else {
            for (int i = 0; i < maximumTries && this.extractFluidToItem(player, fluidSlot, shift); ++i) {
            }
        }
    }

    private boolean insertFluidFromItem(ServerPlayer player, FluidSlot fluidSlot, boolean shift) {
        int maxAmountToFill;
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.m_150109_());
        ItemStack stack = this.m_142621_();
        LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        FluidStack drainedFluidStack = handler.drain(maxAmountToFill = fluidSlot.getRemainingSlotCapacity(), IFluidHandler.FluidAction.EXECUTE);
        if (drainedFluidStack.isEmpty() || !fluidSlot.mayPlace(drainedFluidStack)) {
            return false;
        }
        boolean slotEmpty = fluidSlot.getFluid().isEmpty();
        if (!slotEmpty && !drainedFluidStack.isFluidEqual(fluidSlot.getFluid())) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.m_41613_() == 1 && !shift) {
            if (slotEmpty) {
                fluidSlot.set(drainedFluidStack);
            } else {
                fluidSlot.getFluid().grow(drainedFluidStack.getAmount());
                fluidSlot.setChanged();
            }
            this.m_142503_(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).m_41619_()) {
            if (slotEmpty) {
                fluidSlot.set(drainedFluidStack);
            } else {
                fluidSlot.getFluid().grow(drainedFluidStack.getAmount());
                fluidSlot.setChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                this.m_142503_(ItemStack.f_41583_);
            }
        }
        return true;
    }

    private boolean extractFluidToItem(ServerPlayer player, FluidSlot fluidSlot, boolean shift) {
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.m_150109_());
        ItemStack stack = this.m_142621_();
        LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        int amountFilled = handler.fill(fluidSlot.getFluid(), IFluidHandler.FluidAction.EXECUTE);
        if (amountFilled <= 0) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.m_41613_() == 1 && !shift) {
            fluidSlot.getFluid().shrink(amountFilled);
            if (fluidSlot.getFluid().isEmpty()) {
                fluidSlot.set(FluidStack.EMPTY);
            } else {
                fluidSlot.setChanged();
            }
            this.m_142503_(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).m_41619_()) {
            fluidSlot.getFluid().shrink(amountFilled);
            if (fluidSlot.getFluid().isEmpty()) {
                fluidSlot.set(FluidStack.EMPTY);
            } else {
                fluidSlot.setChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                this.m_142503_(ItemStack.f_41583_);
            }
        }
        return true;
    }

    public void m_150429_() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            this.remoteFluidSlots.set(slot, (Object)this.fluidSlots.get(slot).getFluid().copy());
        }
        if (this.getSynchronizerPlayer() != null) {
            UCoreNetwork.NETWORK.send(PacketDistributor.PLAYER.with(this::getSynchronizerPlayer), (Object)new ContainerSetFluidContentMessage(this.f_38840_, this.m_182425_(), (List<FluidStack>)this.remoteFluidSlots));
        }
        super.m_150429_();
    }

    public void m_38946_() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getFluid();
            Supplier supplier = Suppliers.memoize(() -> ((FluidStack)stack).copy());
            this.triggerFluidSlotListeners(slot, stack, (java.util.function.Supplier<FluidStack>)supplier);
            this.synchronizeFluidSlotToRemote(slot, stack, (java.util.function.Supplier<FluidStack>)supplier);
        }
        super.m_38946_();
    }

    public void m_182423_() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getFluid();
            this.triggerFluidSlotListeners(slot, stack, () -> ((FluidStack)stack).copy());
        }
        super.m_182423_();
    }

    private void triggerFluidSlotListeners(int slotId, FluidStack stack, java.util.function.Supplier<FluidStack> supplier) {
        FluidStack lastStack = (FluidStack)this.lastFluidSlots.get(slotId);
        if (!lastStack.isFluidStackIdentical(stack)) {
            FluidStack copy = supplier.get();
            this.lastFluidSlots.set(slotId, (Object)copy);
            for (ContainerListener listener : this.f_38848_) {
                if (!(listener instanceof FluidContainerListener)) continue;
                FluidContainerListener fluidListener = (FluidContainerListener)listener;
                fluidListener.fluidSlotChanged(this, slotId, copy);
            }
        }
    }

    private void synchronizeFluidSlotToRemote(int slotId, FluidStack stack, java.util.function.Supplier<FluidStack> supplier) {
        FluidStack remoteStack;
        if (!this.f_150398_ && !(remoteStack = (FluidStack)this.remoteFluidSlots.get(slotId)).isFluidStackIdentical(stack)) {
            FluidStack copy = supplier.get();
            this.remoteFluidSlots.set(slotId, (Object)copy);
            if (this.getSynchronizerPlayer() != null) {
                UCoreNetwork.NETWORK.send(PacketDistributor.PLAYER.with(this::getSynchronizerPlayer), (Object)new ContainerSetFluidSlotMessage(this.f_38840_, this.m_182425_(), slotId, copy));
            }
        }
    }

    public void setRemoteFluidSlot(int slotId, FluidStack stack) {
        this.remoteFluidSlots.set(slotId, (Object)stack.copy());
    }

    public void setRemoteFluidSlotNoCopy(int slotId, FluidStack stack) {
        this.remoteFluidSlots.set(slotId, (Object)stack);
    }

    public void setFluid(int slotId, int stateId, FluidStack stack) {
        this.getFluidSlot(slotId).set(stack);
        this.f_182405_ = stateId;
    }

    public void initializeFluidContents(int stateId, List<FluidStack> stacks) {
        for (int index = 0; index < stacks.size(); ++index) {
            this.getFluidSlot(index).set(stacks.get(index));
        }
        this.f_182405_ = stateId;
    }

    protected List<FluidStack> getLastFluidSlots() {
        return this.lastFluidSlots;
    }

    protected void addFluidSlots(FluidHandlerModifiable handler, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, 0, inventoryHeight, inventoryWidth, x, y);
    }

    protected void addFluidSlots(FluidHandlerModifiable handler, FluidSlotHandlerFunction function, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, function, 0, inventoryHeight, inventoryWidth, x, y);
    }

    protected void addFluidSlots(FluidHandlerModifiable handler, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, FluidSlot::new, startIndex, inventoryHeight, inventoryWidth, x, y);
    }

    protected void addFluidSlots(FluidHandlerModifiable handler, FluidSlotHandlerFunction function, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        for (int height = 0; height < inventoryHeight; ++height) {
            for (int width = 0; width < inventoryWidth; ++width) {
                this.addFluidSlot(function.getSlot(handler, startIndex + (width + height * inventoryWidth), width * 18 + x, height * 18 + y));
            }
        }
    }

    @FunctionalInterface
    public static interface FluidSlotHandlerFunction {
        public FluidSlot getSlot(FluidHandlerModifiable var1, int var2, int var3, int var4);
    }
}

