/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

public class RGBA {
    public static final RGBA BLACK = new RGBA(255);
    public static final RGBA WHITE = new RGBA(-1);
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;
    private final int colorRGBA;
    private final int colorARGB;

    public RGBA(int color) {
        this.red = color >> 24 & 0xFF;
        this.green = color >> 16 & 0xFF;
        this.blue = color >> 8 & 0xFF;
        this.alpha = color & 0xFF;
        this.colorRGBA = color;
        this.colorARGB = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public RGBA(int red, int green, int blue, int alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        this.colorRGBA = (this.red & 0xFF) << 24 | (this.green & 0xFF) << 16 | (this.blue & 0xFF) << 8 | this.alpha & 0xFF;
        this.colorARGB = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public RGBA(float red, float green, float blue, float alpha) {
        this.red = (int)(red * 255.0f);
        this.green = (int)(green * 255.0f);
        this.blue = (int)(blue * 255.0f);
        this.alpha = (int)(alpha * 255.0f);
        this.colorRGBA = (this.red & 0xFF) << 24 | (this.green & 0xFF) << 16 | (this.blue & 0xFF) << 8 | this.alpha & 0xFF;
        this.colorARGB = (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public float getRedComponent() {
        return (float)this.red / 255.0f;
    }

    public float getGreenComponent() {
        return (float)this.green / 255.0f;
    }

    public float getBlueComponent() {
        return (float)this.blue / 255.0f;
    }

    public float getAlphaComponent() {
        return (float)this.alpha / 255.0f;
    }

    public int getColor() {
        return this.colorRGBA;
    }

    public int getColorARGB() {
        return this.colorARGB;
    }

    public RGBA setRed(int red) {
        return new RGBA(red, this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public RGBA setGreen(int green) {
        return new RGBA(this.getRed(), green, this.getBlue(), this.getAlpha());
    }

    public RGBA setBlue(int blue) {
        return new RGBA(this.getRed(), this.getGreen(), blue, this.getAlpha());
    }

    public RGBA setAlpha(int alpha) {
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public RGBA setRedComponent(float red) {
        return new RGBA((int)(red * 255.0f), this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public RGBA setGreenComponent(float green) {
        return new RGBA(this.getRed(), (int)(green * 255.0f), this.getBlue(), this.getAlpha());
    }

    public RGBA setBlueComponent(float blue) {
        return new RGBA(this.getRed(), this.getGreen(), (int)(blue * 255.0f), this.getAlpha());
    }

    public RGBA setAlphaComponent(float alpha) {
        return new RGBA(this.getRed(), this.getGreen(), this.getBlue(), (int)(alpha * 255.0f));
    }

    public String toString() {
        return "RGBA [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    public static RGBA fromARGB(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = color >> 24 & 0xFF;
        return new RGBA(red, green, blue, alpha);
    }
}

