/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.verify;

import com.google.common.base.Stopwatch;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.CertificateHelper;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarSignVerifier {
    private static final Logger LOGGER = LogManager.getLogger((String)"JarSignVerifier");

    public static void checkSigned(String modid) {
        Stopwatch watch = Stopwatch.createStarted();
        VerifyStatus status = JarSignVerifier.verify(modid);
        watch.stop();
        LOGGER.debug("Took {} to check if mod {} is signed.", (Object)watch, (Object)modid);
        if (status == VerifyStatus.SIGNED) {
            LOGGER.info("Mod " + modid + " is signed with a valid certificate.");
        } else if (status == VerifyStatus.UNSIGNED) {
            LOGGER.warn("---------------------------------------------------------------------------------");
            LOGGER.warn("Mod " + modid + " is not signed with a valid certificate but should be signed.");
            LOGGER.warn("Please download the mod only from trusted sources such as curseforge.com!");
            LOGGER.warn("---------------------------------------------------------------------------------");
        } else if (status == VerifyStatus.DEV) {
            LOGGER.info("Mod " + modid + " is loaded in dev environment.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VerifyStatus verify(String modid) {
        IModFileInfo info = ModList.get().getModFileById(modid);
        if (!FMLEnvironment.production) {
            return VerifyStatus.DEV;
        }
        Path path = info.getFile().getFilePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return VerifyStatus.DEV;
        }
        try (JarFile jarFile = new JarFile(path.toFile());){
            Optional<String> fingerPrintOptional = JarSignVerifier.getFingerPrint(Optional.ofNullable(jarFile.getManifest()));
            if (!fingerPrintOptional.isPresent()) {
                VerifyStatus verifyStatus = VerifyStatus.UNSIGNED;
                return verifyStatus;
            }
            String fingerprint = fingerPrintOptional.get();
            try (Stream<JarEntry> entryStream = jarFile.stream();){
                if (entryStream.filter(JarSignVerifier::checkEntryForSign).allMatch(entry -> {
                    try (InputStream stream = jarFile.getInputStream((ZipEntry)entry);){
                        ByteStreams.copy((InputStream)stream, (OutputStream)ByteStreams.nullOutputStream());
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    return CertificateHelper.getFingerprints((Certificate[])entry.getCertificates()).stream().filter(fingerprint::equals).findAny().isPresent();
                })) {
                    VerifyStatus verifyStatus = VerifyStatus.SIGNED;
                    return verifyStatus;
                }
            }
            VerifyStatus verifyStatus = VerifyStatus.UNSIGNED;
            return verifyStatus;
        }
        catch (Exception ex) {
            return VerifyStatus.UNSIGNED;
        }
    }

    private static boolean checkEntryForSign(JarEntry entry) {
        if (entry.isDirectory()) {
            return false;
        }
        String name = entry.getName().toUpperCase();
        return !name.endsWith(".SF") && !name.endsWith(".DSA") && !name.endsWith(".EC") && !name.endsWith(".RSA");
    }

    private static Optional<String> getFingerPrint(Optional<Manifest> manifest) {
        return manifest.map(Manifest::getMainAttributes).map(attributes -> attributes.getValue("Fingerprint")).map(fingerPrint -> fingerPrint.replace(":", "").toLowerCase());
    }

    public static enum VerifyStatus {
        SIGNED,
        UNSIGNED,
        DEV;

    }
}

