/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.sync;

import info.u_team.u_team_core.api.sync.BufferReferenceHolder;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;

public class MessageHolder
extends BufferReferenceHolder {
    private Supplier<PacketBuffer> send;
    private final Consumer<PacketBuffer> receive;
    private boolean isTriggered;

    public MessageHolder(Consumer<PacketBuffer> receive) {
        this.receive = receive;
    }

    @Override
    public PacketBuffer get() {
        return this.send.get();
    }

    @Override
    public void set(PacketBuffer buffer) {
        this.receive.accept(buffer);
    }

    @Override
    public boolean isDirty() {
        if (this.isTriggered) {
            this.isTriggered = false;
            return true;
        }
        return false;
    }

    public void triggerMessage(Supplier<PacketBuffer> send) {
        this.isTriggered = true;
        this.send = send;
    }

    public static class EmptyMessageHolder
    extends MessageHolder {
        public EmptyMessageHolder(Runnable receive) {
            super((PacketBuffer packet) -> receive.run());
        }

        public void triggerMessage() {
            this.triggerMessage(() -> new PacketBuffer(Unpooled.EMPTY_BUFFER));
        }
    }
}

