/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new FluidIngredient(0, Stream.empty());
    private final IFluidList[] acceptedFluids;
    private final FluidStack[] matchingFluids;
    private final int amount;

    public static FluidIngredient fromFluids(int amount, Fluid ... fluids) {
        return new FluidIngredient(amount, Arrays.stream(fluids).map(fluid -> new SingleFluidList(new FluidStack(fluid, 1000))));
    }

    public static FluidIngredient fromStacks(int amount, FluidStack ... stacks) {
        return new FluidIngredient(amount, Arrays.stream(stacks).map(stack -> new SingleFluidList((FluidStack)stack)));
    }

    public static FluidIngredient fromTag(int amount, Tag<Fluid> tag) {
        return new FluidIngredient(amount, Stream.of(new TagList(tag)));
    }

    protected FluidIngredient(int amount, Stream<? extends IFluidList> stream) {
        this.amount = amount;
        this.acceptedFluids = (IFluidList[])stream.filter(list -> !list.getStacks().stream().allMatch(FluidStack::isEmpty)).toArray(IFluidList[]::new);
        this.matchingFluids = (FluidStack[])Arrays.stream(this.acceptedFluids).flatMap(fluidList -> fluidList.getStacks().stream()).distinct().toArray(FluidStack[]::new);
    }

    @Override
    public boolean test(FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.matchingFluids.length == 0) {
            return stack.isEmpty();
        }
        for (FluidStack fluidStack : this.matchingFluids) {
            if (fluidStack.getFluid() != stack.getFluid()) continue;
            return stack.getAmount() >= this.amount;
        }
        return false;
    }

    public int getAmount() {
        return this.amount;
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.amount);
        buffer.func_150787_b(this.matchingFluids.length);
        for (FluidStack stack : this.matchingFluids) {
            buffer.writeFluidStack(stack);
        }
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        int amount = buffer.readInt();
        int length = buffer.func_150792_a();
        return new FluidIngredient(amount, Stream.generate(() -> new SingleFluidList(buffer.readFluidStack())).limit(length));
    }

    public JsonElement serialize() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.acceptedFluids.length == 1) {
            jsonObject.add("fluids", (JsonElement)this.acceptedFluids[0].serialize());
        } else {
            JsonArray jsonArray = new JsonArray();
            for (IFluidList list : this.acceptedFluids) {
                jsonArray.add((JsonElement)list.serialize());
            }
            jsonObject.add("fluids", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static FluidIngredient deserialize(JsonElement jsonElement) {
        if (jsonElement == null || !jsonElement.isJsonObject()) {
            throw new JsonSyntaxException("Fluid ingredient must be a json object");
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (!jsonObject.has("amount") || !jsonObject.has("fluids")) {
            throw new JsonSyntaxException("Expected amount and fluids");
        }
        int amount = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount");
        JsonElement ingredientJsonElement = jsonObject.get("fluids");
        if (ingredientJsonElement.isJsonObject()) {
            return new FluidIngredient(amount, Stream.of(FluidIngredient.deserializeFluidList(ingredientJsonElement.getAsJsonObject())));
        }
        if (ingredientJsonElement.isJsonArray()) {
            JsonArray jsonArray = ingredientJsonElement.getAsJsonArray();
            if (jsonArray.size() == 0) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
            }
            return new FluidIngredient(amount, StreamSupport.stream(jsonArray.spliterator(), false).map(jsonArrayElement -> FluidIngredient.deserializeFluidList(JSONUtils.func_151210_l((JsonElement)jsonArrayElement, (String)"fluid"))));
        }
        throw new JsonSyntaxException("Expected fluid to be object or array of objects");
    }

    protected static IFluidList deserializeFluidList(JsonObject jsonObject) {
        if (jsonObject.has("fluid") && jsonObject.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or a fluid, not both");
        }
        if (jsonObject.has("fluid")) {
            ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid"));
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(key);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid '" + key + "'");
            }
            return new SingleFluidList(new FluidStack(fluid, 1000));
        }
        if (jsonObject.has("tag")) {
            ResourceLocation key = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            Tag tag = FluidTags.func_226157_a_().func_199910_a(key);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown fluid tag '" + key + "'");
            }
            return new TagList((Tag<Fluid>)tag);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or a fluid");
    }

    public static class TagList
    implements IFluidList {
        private final Tag<Fluid> tag;

        public TagList(Tag<Fluid> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<FluidStack> getStacks() {
            ArrayList list = Lists.newArrayList();
            for (Fluid fluid : this.tag.func_199885_a()) {
                list.add(new FluidStack(fluid, 1000));
            }
            if (list.size() == 0 && !((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue()) {
                list.add(new FluidStack((Fluid)Fluids.field_204547_b, Integer.MAX_VALUE));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.func_199886_b().toString());
            return jsonObject;
        }
    }

    public static class SingleFluidList
    implements IFluidList {
        private final FluidStack stack;

        public SingleFluidList(FluidStack stack) {
            this.stack = stack;
        }

        @Override
        public Collection<FluidStack> getStacks() {
            return Collections.singleton(this.stack);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)this.stack.getFluid()).toString());
            return jsonObject;
        }
    }

    public static interface IFluidList {
        public Collection<FluidStack> getStacks();

        public JsonObject serialize();
    }
}

