/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import info.u_team.u_team_core.ingredient.FluidIngredient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SerializeUtil {
    public static JsonElement serializeItemIngredient(Ingredient ingredient) {
        return ingredient.func_200304_c();
    }

    public static Ingredient deserializeItemIngredient(JsonElement json) {
        return Ingredient.func_199802_a((JsonElement)json);
    }

    public static JsonElement serializeFluidIngredient(FluidIngredient ingredient) {
        return ingredient.serialize();
    }

    public static FluidIngredient deserializeFluidIngredient(JsonElement json) {
        return FluidIngredient.deserialize(json);
    }

    public static JsonElement serializeItemStack(ItemStack stack) {
        String itemName = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stack.func_77973_b()).toString();
        int count = stack.func_190916_E();
        if (stack.func_77942_o() || count != 1) {
            JsonObject object = new JsonObject();
            object.addProperty("item", itemName);
            if (count != 1) {
                object.addProperty("count", (Number)stack.func_190916_E());
            }
            if (stack.func_77942_o()) {
                object.addProperty("nbt", stack.func_77978_p().toString());
            }
            return object;
        }
        return new JsonPrimitive(itemName);
    }

    public static ItemStack deserializeItemStack(JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject(), (boolean)true);
            }
            if (json.isJsonPrimitive()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.getAsString()));
                if (item == null) {
                    throw new IllegalStateException("Item: " + json.getAsString() + " does not exist");
                }
                return new ItemStack((IItemProvider)item);
            }
            throw new JsonSyntaxException("Expected item to be object or array of objects");
        }
        throw new JsonSyntaxException("Item cannot be null");
    }
}

