/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CommonDeferredRegister<R extends IForgeRegistryEntry<R>>
implements Iterable<RegistryObject<R>> {
    private final String modid;
    private final DeferredRegister<R> register;

    public static <C extends IForgeRegistryEntry<C>> CommonDeferredRegister<C> create(IForgeRegistry<C> registry, String modid) {
        return new CommonDeferredRegister<C>(registry, modid);
    }

    protected CommonDeferredRegister(IForgeRegistry<R> registry, String modid) {
        this.modid = modid;
        this.register = DeferredRegister.create(registry, (String)modid);
    }

    public <E extends R> RegistryObject<E> register(String name, Function<ResourceLocation, ? extends E> function) {
        return this.register(name, () -> (IForgeRegistryEntry)function.apply(new ResourceLocation(this.modid, name)));
    }

    public <E extends R> RegistryObject<E> register(String name, Supplier<? extends E> supplier) {
        return this.register.register(name, supplier);
    }

    public void register(IEventBus bus) {
        this.register.register(bus);
    }

    public String getModid() {
        return this.modid;
    }

    public Collection<RegistryObject<R>> getEntries() {
        return this.register.getEntries();
    }

    @Override
    public Iterator<RegistryObject<R>> iterator() {
        return this.register.getEntries().iterator();
    }
}

