/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CommonBlockStateProvider
extends BlockStateProvider
implements CommonDataProvider.NoParam {
    private final GenerationData generationData;

    public CommonBlockStateProvider(GenerationData generationData) {
        super(generationData.output(), generationData.modid(), generationData.existingFileHelper());
        this.generationData = generationData;
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    protected final void registerStatesAndModels() {
        this.register(null);
    }

    public String getName() {
        return "Block-State: " + this.nameSuffix();
    }

    protected void facingBlock(Block block, ModelFile modelFile) {
        this.facingBlock(block, modelFile, 0);
    }

    protected void facingBlock(Block block, ModelFile modelFile, int angleOffset) {
        this.facingBlock(block, (BlockState $) -> modelFile, angleOffset);
    }

    protected void facingBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(direction == Direction.DOWN ? 90 : (direction == Direction.UP ? 270 : 0)).rotationY(direction.getAxis().isVertical() ? 0 : ((int)direction.toYRot() + angleOffset + 180) % 360).build();
        });
    }

    protected BlockModelBuilder cubeFacing(String name, ResourceLocation front, ResourceLocation side) {
        return this.cubeFacing(name, front, side, side);
    }

    protected BlockModelBuilder cubeFacing(String name, ResourceLocation front, ResourceLocation side, ResourceLocation particle) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"uteamcore", (String)"block/facing")))).texture("particle", particle)).texture("front", front)).texture("side", side);
    }

    protected BlockModelBuilder cubeFacingBottomTop(String name, ResourceLocation front, ResourceLocation bottom, ResourceLocation top, ResourceLocation side) {
        return this.cubeFacingBottomTop(name, front, bottom, top, side, side);
    }

    protected BlockModelBuilder cubeFacingBottomTop(String name, ResourceLocation front, ResourceLocation bottom, ResourceLocation top, ResourceLocation side, ResourceLocation particle) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"uteamcore", (String)"block/facing_bottom_top")))).texture("particle", particle)).texture("front", front)).texture("bottom", bottom)).texture("top", top)).texture("side", side);
    }

    protected String getPath(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).getPath();
    }
}

