/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.data;

import info.u_team.u_team_core.data.CommonDataProvider;
import info.u_team.u_team_core.data.GenerationData;
import info.u_team.u_team_core.intern.loot_item_function.SetBlockEntityNBTLootItemFunction;
import info.u_team.u_team_core.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class CommonLootTableProvider
implements DataProvider,
CommonDataProvider<LootTableRegister> {
    private final GenerationData generationData;
    private final PackOutput.PathProvider pathProvider;

    public CommonLootTableProvider(GenerationData generationData) {
        this.generationData = generationData;
        this.pathProvider = generationData.output().createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
    }

    @Override
    public GenerationData getGenerationData() {
        return this.generationData;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        return this.withRegistries(registries -> {
            ArrayList futures = new ArrayList();
            this.register(new LootTableRegister(){
                final /* synthetic */ HolderLookup.Provider val$registries;
                final /* synthetic */ List val$futures;
                final /* synthetic */ CachedOutput val$cache;
                {
                    this.val$registries = provider;
                    this.val$futures = list;
                    this.val$cache = cachedOutput;
                }

                @Override
                public HolderLookup.Provider registries() {
                    return this.val$registries;
                }

                @Override
                public void register(ResourceLocation location, LootTable lootTable) {
                    this.val$futures.add(CommonLootTableProvider.this.saveData(this.val$cache, this.val$registries, LootTable.DIRECT_CODEC, lootTable, CommonLootTableProvider.this.pathProvider.json(location)));
                }
            });
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "Loot-Table: " + this.nameSuffix();
    }

    protected static void registerBlock(Supplier<? extends Block> supplier, LootTable.Builder builder, LootTableRegister register) {
        CommonLootTableProvider.registerBlock(supplier.get(), builder, register);
    }

    protected static void registerBlock(Block block, LootTable.Builder builder, LootTableRegister register) {
        ResourceLocation location = RegistryUtil.getBuiltInRegistry(Registries.BLOCK).getKey((Object)block).withPrefix("blocks/");
        register.register(location, builder.setRandomSequence(location).build());
    }

    protected static LootTable.Builder addBasicBlockLootTable(ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).when(ExplosionCondition.survivesExplosion()));
    }

    protected static LootTable.Builder addBlockEntityBlockLootTable(ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)).apply(SetBlockEntityNBTLootItemFunction.builder()).when(ExplosionCondition.survivesExplosion()));
    }

    protected static LootTable.Builder addFortuneBlockLootTable(HolderLookup.Provider registries, Block block, ItemLike item) {
        return LootTable.lootTable().setParamSet(LootContextParamSets.BLOCK).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1)))))))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()))));
    }

    public static interface LootTableRegister {
        public void register(ResourceLocation var1, LootTable var2);

        public HolderLookup.Provider registries();
    }
}

