/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.SiUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageWidget
extends AbstractWidget
implements PerspectiveRenderable,
TooltipRenderable {
    public static final ResourceLocation ENERGY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"uteamcore", (String)"textures/gui/energy.png");
    private final LongSupplier capacity;
    private final LongSupplier storage;
    protected ResourceLocation texture;
    protected RGBA color;

    public EnergyStorageWidget(int x, int y, int height, Supplier<IEnergyStorage> energyStorage) {
        this(x, y, height, () -> ((IEnergyStorage)energyStorage.get()).getMaxEnergyStored(), () -> ((IEnergyStorage)energyStorage.get()).getEnergyStored());
    }

    public EnergyStorageWidget(int x, int y, int height, LongSupplier capacity, LongSupplier storage) {
        super(x, y, 14, height < 3 ? 3 : height, (Component)Component.empty());
        this.capacity = capacity;
        this.storage = storage;
        this.texture = ENERGY_TEXTURE;
        this.color = RGBA.WHITE;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        WidgetUtil.renderCustomTooltipForWidget(this, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int yComponent;
        double ratio = (double)this.storage.getAsLong() / (double)this.capacity.getAsLong();
        if (ratio > 1.0) {
            ratio = 1.0;
        }
        int storageOffset = (int)((1.0 - ratio) * (double)(this.height - 2));
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderUtil.setShaderColor(this.color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (yComponent = 1; yComponent < this.height - 1; yComponent += 2) {
            RenderUtil.addTexturedQuad(bufferBuilder, guiGraphics.pose(), this.x + 1, this.x + 1 + 12, this.y + yComponent, this.y + yComponent + 2, 0.0f, 0.75f, 0.0f, 0.125f, 0.0f);
        }
        for (yComponent = 1 + storageOffset; yComponent < this.height - 1; ++yComponent) {
            if (yComponent % 2 == 0) {
                RenderUtil.addTexturedQuad(bufferBuilder, guiGraphics.pose(), this.x + 1, this.x + 1 + 12, this.y + yComponent, this.y + yComponent + 1, 0.0f, 0.75f, 0.1875f, 0.25f, 0.0f);
                continue;
            }
            RenderUtil.addTexturedQuad(bufferBuilder, guiGraphics.pose(), this.x + 1, this.x + 1 + 12, this.y + yComponent, this.y + yComponent + 1, 0.0f, 0.75f, 0.125f, 0.1875f, 0.0f);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.drawContainerBorder(guiGraphics.pose(), this.x, this.y, this.width, this.height, 0.0f, RGBA.WHITE);
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered) {
            Object capacityString;
            Object storageString;
            Minecraft minecraft = Minecraft.getInstance();
            if (!Screen.hasShiftDown()) {
                storageString = SiUtil.readableSi(this.storage.getAsLong());
                capacityString = SiUtil.readableSi(this.capacity.getAsLong());
            } else {
                storageString = Long.toString(this.storage.getAsLong()) + " ";
                capacityString = Long.toString(this.capacity.getAsLong()) + " ";
            }
            List<MutableComponent> list = List.of(Component.translatable((String)"gui.widget.uteamcore.energy.fe_tooltip", (Object[])new Object[]{storageString, capacityString}));
            guiGraphics.renderTooltip(minecraft.font, list, Optional.empty(), mouseX, mouseY);
        }
    }

    public void playDownSound(SoundManager handler) {
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

