/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.impl.ForgeCommonRegister;
import info.u_team.u_team_core.impl.common.CommonBlockRegistryEntry;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBlockRegister
implements BlockRegister {
    private final ForgeCommonRegister<Block> blocks;
    private final ForgeCommonRegister<Item> items;
    private final Map<ForgeCommonRegister.ForgeRegistryEntry<? extends Block>, ForgeCommonRegister.ForgeRegistryEntry<? extends Item>> blockToItemsMap;

    ForgeBlockRegister(String modid) {
        this.blocks = new ForgeCommonRegister(Registries.BLOCK, modid);
        this.items = new ForgeCommonRegister(Registries.ITEM, modid);
        this.blockToItemsMap = new LinkedHashMap<ForgeCommonRegister.ForgeRegistryEntry<? extends Block>, ForgeCommonRegister.ForgeRegistryEntry<? extends Item>>();
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryEntry block = this.blocks.register(name, supplier);
        ForgeCommonRegister.ForgeRegistryEntry item = new ForgeCommonRegister.ForgeRegistryEntry(RegistryObject.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.blocks.getModid(), (String)name), (IForgeRegistry)ForgeRegistries.ITEMS));
        this.blockToItemsMap.put((ForgeCommonRegister.ForgeRegistryEntry<? extends Block>)block, item);
        return new ForgeBlockRegistryEntry(block, item);
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<Block, ? extends I> itemFunction) {
        return this.register(name, (Supplier)blockSupplier, () -> (Item)itemFunction.apply((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)this.blocks.getModid(), (String)name))));
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryEntry block = this.blocks.register(name, blockSupplier);
        RegistryEntry item = this.items.register(name, itemSupplier);
        return new ForgeBlockRegistryEntry(block, item);
    }

    public <B extends Block> ForgeCommonRegister.ForgeRegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    @Override
    public void register() {
        this.blocks.register();
        this.items.register();
        BusRegister.registerMod(bus -> bus.addListener(this::registerItems));
    }

    private void registerItems(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.ITEMS)) {
            this.blockToItemsMap.forEach((? super K blockObject, ? super V itemObject) -> {
                BlockItemProvider blockItemProvider;
                Item blockItem;
                Block block = (Block)blockObject.get();
                if (block instanceof BlockItemProvider && (blockItem = (blockItemProvider = (BlockItemProvider)block).blockItem()) != null) {
                    event.register(ForgeRegistries.Keys.ITEMS, itemObject.getId(), () -> blockItem);
                }
            });
        }
    }

    @Override
    public String getModid() {
        return this.blocks.getModid();
    }

    @Override
    public Iterator<RegistryEntry<Block>> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public Iterable<Block> blockIterable() {
        return this.blocks.entryIterable();
    }

    @Override
    public Iterable<Item> itemIterable() {
        return () -> this.blocks.getEntries().stream().map(block -> {
            Item item = ((Block)block.get()).asItem();
            if (item != null && item != Items.AIR) {
                return Optional.of(item);
            }
            return Optional.empty();
        }).flatMap(Optional::stream).iterator();
    }

    public ForgeCommonRegister<Block> getBlockRegister() {
        return this.blocks;
    }

    public ForgeCommonRegister<Item> getItemRegister() {
        return this.items;
    }

    public static class ForgeBlockRegistryEntry<B extends Block, I extends Item>
    extends CommonBlockRegistryEntry<B, I, ForgeCommonRegister.ForgeRegistryEntry<B>, ForgeCommonRegister.ForgeRegistryEntry<I>> {
        ForgeBlockRegistryEntry(ForgeCommonRegister.ForgeRegistryEntry<B> block, ForgeCommonRegister.ForgeRegistryEntry<I> item) {
            super(block, item);
        }

        public RegistryObject<B> getBlockRegistryObject() {
            return ((ForgeCommonRegister.ForgeRegistryEntry)this.getBlockEntry()).getRegistryObject();
        }

        public RegistryObject<I> getItemRegistryObject() {
            return ((ForgeCommonRegister.ForgeRegistryEntry)this.getItemEntry()).getRegistryObject();
        }
    }

    public static class Factory
    implements BlockRegister.Factory {
        @Override
        public BlockRegister create(String modid) {
            return new ForgeBlockRegister(modid);
        }
    }
}

