/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl;

import com.google.common.base.Suppliers;
import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkHandlerEnvironment;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.impl.common.CommonNetworkHandler;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.EnvironmentUtil;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.payload.PayloadConnection;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;

public class ForgeNetworkHandler
extends CommonNetworkHandler {
    private Channel<CustomPacketPayload> forgeChannel;

    ForgeNetworkHandler(ResourceLocation channel, int protocolVersion) {
        super(channel, protocolVersion);
    }

    @Override
    public <M> NetworkMessage<M> createNetworkMessage(CommonNetworkHandler.MessagePacketPayload<M> messagePayload) {
        return new ForgeNetworkMessage<M>(messagePayload, () -> this.forgeChannel);
    }

    @Override
    public void register() {
        PayloadConnection payloadChannel = ChannelBuilder.named((ResourceLocation)this.networkId).networkProtocolVersion(this.protocolVersion).optionalServer().payloadChannel();
        PayloadProtocol lastMessage = null;
        for (CommonNetworkHandler.MessagePacketPayload messagePayload : this.messages.values()) {
            PayloadProtocol builder = lastMessage == null ? payloadChannel.play() : lastMessage;
            NetworkHandlerEnvironment environment = messagePayload.payload().handlerEnvironment();
            BiConsumer<CustomPacketPayload, CustomPayloadEvent.Context> handler = (payload, context) -> {
                messagePayload.handle((CustomPacketPayload)payload, (NetworkContext)new ForgeNetworkContext(messagePayload, (CustomPayloadEvent.Context)context));
                context.setPacketHandled(true);
            };
            if (environment == NetworkHandlerEnvironment.CLIENT) {
                lastMessage = ((PayloadFlow)builder.clientbound()).add(messagePayload.type(), this.cast(messagePayload.streamCodec()), handler);
                continue;
            }
            if (environment == NetworkHandlerEnvironment.SERVER) {
                lastMessage = ((PayloadFlow)builder.serverbound()).add(messagePayload.type(), this.cast(messagePayload.streamCodec()), handler);
                continue;
            }
            if (environment != NetworkHandlerEnvironment.BOTH) continue;
            lastMessage = ((PayloadFlow)builder.bidirectional()).add(messagePayload.type(), this.cast(messagePayload.streamCodec()), handler);
        }
        this.forgeChannel = lastMessage.build();
    }

    private StreamCodec<RegistryFriendlyByteBuf, CustomPacketPayload> cast(StreamCodec<? super RegistryFriendlyByteBuf, CustomPacketPayload> codec) {
        return (StreamCodec)CastUtil.uncheckedCast(codec);
    }

    public static class ForgeNetworkMessage<M>
    extends CommonNetworkHandler.CommonNetworkMessage<M> {
        private final Supplier<Channel<CustomPacketPayload>> forgeChannelSupplier = Suppliers.memoize(forgeChannelSupplier::get);

        private ForgeNetworkMessage(CommonNetworkHandler.MessagePacketPayload<M> messagePayload, Supplier<Channel<CustomPacketPayload>> forgeChannelSupplier) {
            super(messagePayload);
        }

        public Channel<CustomPacketPayload> forgeChannel() {
            Channel<CustomPacketPayload> forgeChannel = this.forgeChannelSupplier.get();
            if (forgeChannel == null) {
                throw new IllegalStateException("Forge channel has not been registered");
            }
            return forgeChannel;
        }

        @Override
        public Packet<?> packet(NetworkEnvironment toEnvironment, M message) {
            Channel<CustomPacketPayload> forgeChannel = this.forgeChannel();
            CustomPacketPayload payload = this.packet((Object)message);
            return switch (toEnvironment) {
                default -> throw new MatchException(null, null);
                case NetworkEnvironment.CLIENT -> NetworkDirection.PLAY_TO_CLIENT.buildPacket(forgeChannel, (Object)payload);
                case NetworkEnvironment.SERVER -> NetworkDirection.PLAY_TO_SERVER.buildPacket(forgeChannel, (Object)payload);
            };
        }
    }

    private static class ForgeNetworkContext<M>
    extends CommonNetworkHandler.CommonNetworkContext<M> {
        private final CustomPayloadEvent.Context context;

        private ForgeNetworkContext(CommonNetworkHandler.MessagePacketPayload<M> messagePayload, CustomPayloadEvent.Context context) {
            super(messagePayload);
            this.context = context;
        }

        @Override
        public NetworkEnvironment getEnvironment() {
            return this.context.isClientSide() ? NetworkEnvironment.CLIENT : NetworkEnvironment.SERVER;
        }

        @Override
        public Player getPlayer() {
            if (this.context.isClientSide()) {
                return (Player)EnvironmentUtil.callWhen(Platform.Environment.CLIENT, () -> () -> Client.getClientPlayer());
            }
            return this.context.getSender();
        }

        @Override
        public CompletableFuture<Void> execute(Runnable runnable) {
            return this.context.enqueueWork(runnable);
        }
    }

    public static class Factory
    implements NetworkHandler.Factory {
        @Override
        public NetworkHandler create(ResourceLocation location, int protocolVersion) {
            return new ForgeNetworkHandler(location, protocolVersion);
        }
    }

    private static class Client {
        private Client() {
        }

        private static Player getClientPlayer() {
            return Minecraft.getInstance().player;
        }
    }
}

