/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.mixin;

import info.u_team.u_team_core.api.item.UItemExtension;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeItem;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Item.class})
abstract class ItemMixin
implements IForgeItem {
    ItemMixin() {
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof UItemExtension) {
            UItemExtension extension = (UItemExtension)((Object)itemMixin);
            return extension.shouldPlayUpdateAnimation(oldStack, newStack);
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof UItemExtension) {
            UItemExtension extension = (UItemExtension)((Object)itemMixin);
            return extension.canBeDropped(stack, player);
        }
        return super.onDroppedByPlayer(stack, player);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof UItemExtension) {
            UItemExtension extension = (UItemExtension)((Object)itemMixin);
            return extension.updateItemEntity(stack, entity);
        }
        return super.onEntityItemUpdate(stack, entity);
    }
}

