/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.registry;

import com.google.common.collect.Streams;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.util.ServiceUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public interface CommonRegister<R>
extends Iterable<RegistryEntry<R>> {
    public static <C> CommonRegister<C> create(ResourceKey<? extends Registry<C>> key, String modid) {
        return Factory.INSTANCE.create(key, modid);
    }

    public <E extends R> RegistryEntry<E> register(String var1, Function<ResourceLocation, ? extends E> var2);

    public <E extends R> RegistryEntry<E> register(String var1, Supplier<? extends E> var2);

    public void register();

    public String getModid();

    public ResourceKey<? extends Registry<R>> getRegistryKey();

    public Collection<RegistryEntry<R>> getEntries();

    @Override
    default public Iterator<RegistryEntry<R>> iterator() {
        return this.getEntries().iterator();
    }

    default public Iterable<R> entryIterable() {
        return () -> Streams.stream((Iterable)this).map(Supplier::get).iterator();
    }

    public static interface Factory {
        public static final Factory INSTANCE = ServiceUtil.load(Factory.class);

        public <C> CommonRegister<C> create(ResourceKey<? extends Registry<C>> var1, String var2);
    }
}

