/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.sync;

import info.u_team.u_team_core.api.sync.DataHolder;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;

public class MessageHolder
extends DataHolder {
    private Supplier<FriendlyByteBuf> send;
    private final Consumer<FriendlyByteBuf> receive;
    private boolean isTriggered;

    public MessageHolder(Consumer<FriendlyByteBuf> receive) {
        this.receive = receive;
    }

    @Override
    public FriendlyByteBuf get() {
        return this.send.get();
    }

    @Override
    public void set(FriendlyByteBuf buffer) {
        this.receive.accept(buffer);
    }

    @Override
    public boolean checkAndClearUpdateFlag() {
        if (this.isTriggered) {
            this.isTriggered = false;
            return true;
        }
        return false;
    }

    public void triggerMessage(Supplier<FriendlyByteBuf> send) {
        this.isTriggered = true;
        this.send = send;
    }

    public static class EmptyMessageHolder
    extends MessageHolder {
        public EmptyMessageHolder(Runnable receive) {
            super((FriendlyByteBuf packet) -> receive.run());
        }

        public void triggerMessage() {
            this.triggerMessage(() -> new FriendlyByteBuf(Unpooled.EMPTY_BUFFER));
        }
    }
}

