/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.factory;

import com.google.common.collect.Streams;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.BlockRegistryEntry;
import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.factory.ForgeCommonRegister;
import info.u_team.u_team_core.util.registry.BlockDeferredRegister;
import info.u_team.u_team_core.util.registry.BlockRegistryObject;
import info.u_team.u_team_core.util.registry.BusRegister;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ForgeBlockRegister
implements BlockRegister {
    private final BlockDeferredRegister register;

    ForgeBlockRegister(String modid) {
        this.register = BlockDeferredRegister.create(modid);
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
        return new ForgeBlockRegistryEntry(this.register.register(name, supplier));
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<Block, ? extends I> itemFunction) {
        return new ForgeBlockRegistryEntry<B, I>(this.register.register(name, blockSupplier, itemFunction));
    }

    public <B extends Block, I extends Item> ForgeBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        return new ForgeBlockRegistryEntry<B, I>(this.register.register(name, blockSupplier, itemSupplier));
    }

    public <B extends Block> ForgeCommonRegister.ForgeRegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return new ForgeCommonRegister.ForgeRegistryEntry<B>(this.register.registerBlock(name, supplier));
    }

    @Override
    public void register() {
        BusRegister.registerMod(this.register::register);
    }

    @Override
    public String getModid() {
        return this.register.getBlockRegister().getModid();
    }

    @Override
    public Iterator<RegistryEntry<Block>> iterator() {
        return Streams.stream(this.register.iterator()).map(object -> new ForgeCommonRegister.ForgeRegistryEntry(object)).iterator();
    }

    @Override
    public Iterable<Block> blockIterable() {
        return this.register.blockIterable();
    }

    @Override
    public Iterable<Item> itemIterable() {
        return this.register.itemIterable();
    }

    @Override
    public CommonRegister<Block> getBlockRegister() {
        return new ForgeCommonRegister<Block>(this.register.getBlockRegister());
    }

    @Override
    public CommonRegister<Item> getItemRegister() {
        return new ForgeCommonRegister<Item>(this.register.getItemRegister());
    }

    public static class ForgeBlockRegistryEntry<B extends Block, I extends Item>
    implements BlockRegistryEntry<B, I> {
        private final BlockRegistryObject<B, I> object;

        ForgeBlockRegistryEntry(BlockRegistryObject<B, I> object) {
            this.object = object;
        }

        @Override
        public B get() {
            return this.object.get();
        }

        @Override
        public ResourceLocation getId() {
            return this.object.getId();
        }

        @Override
        public ResourceKey<B> getKey() {
            return this.object.getBlockRegistryObject().getKey();
        }

        @Override
        public Optional<Holder<B>> getHolder() {
            return this.object.getBlockRegistryObject().getHolder();
        }

        @Override
        public boolean isPresent() {
            return this.object.isPresent();
        }

        @Override
        public I getItem() {
            return this.object.getItem();
        }

        @Override
        public ResourceLocation getItemId() {
            return this.object.getItemId();
        }

        @Override
        public ResourceKey<I> getItemKey() {
            return this.object.getItemRegistryObject().getKey();
        }

        @Override
        public Optional<Holder<I>> getItemHolder() {
            return this.object.getItemRegistryObject().getHolder();
        }

        @Override
        public boolean isItemPresent() {
            return this.object.hasItem();
        }

        @Override
        public RegistryEntry<I> getItemRegistryEntry() {
            return new ForgeCommonRegister.ForgeRegistryEntry<I>(this.object.getItemRegistryObject());
        }
    }

    public static class Factory
    implements BlockRegister.Factory {
        @Override
        public BlockRegister create(String modid) {
            return new ForgeBlockRegister(modid);
        }
    }
}

