/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.gui.elements.AbstractSliderLogic;
import info.u_team.u_team_core.gui.elements.UButton;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;

public non-sealed class USlider
extends AbstractSliderLogic
implements WidgetRenderable,
BackgroundColorProvider,
TextProvider,
Scalable,
ScaleProvider {
    protected static final AbstractSliderLogic.OnSliderChange EMPTY_SLIDER = AbstractSliderLogic.EMPTY_SLIDER;
    protected static final RGBA WHITE = UButton.WHITE;
    protected static final RGBA LIGHT_GRAY = UButton.LIGHT_GRAY;
    protected TextureProvider sliderBackgroundTextureProvider = () -> this.getSprite();
    protected RGBA sliderBackgroundColor = WHITE;
    protected TextureProvider sliderTextureProvider = () -> this.getHandleSprite();
    protected RGBA sliderColor = WHITE;
    protected RGBA textColor = WHITE;
    protected RGBA disabledTextColor = LIGHT_GRAY;
    protected float scale = 1.0f;

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, EMPTY_SLIDER);
    }

    public USlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, AbstractSliderLogic.OnSliderChange slider) {
        super(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, slider);
    }

    public RGBA getSliderBackgroundColor() {
        return this.sliderBackgroundColor;
    }

    public void setSliderBackgroundColor(RGBA sliderBackgroundColor) {
        this.sliderBackgroundColor = sliderBackgroundColor;
    }

    public RGBA getSliderColor() {
        return this.sliderColor;
    }

    public void setSliderColor(RGBA sliderColor) {
        this.sliderColor = sliderColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderWidget(this, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderWidgetTexture(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderButtonLikeTexture(this, this.sliderBackgroundTextureProvider, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.setShaderColor(WidgetUtil.respectWidgetAlpha((AbstractWidget)this, this.getCurrentSliderColor(guiGraphics, mouseX, mouseY, partialTick)));
        guiGraphics.blitSprite(this.sliderTextureProvider.getTexture(), this.x + (int)(this.value * (double)(this.width - 8)), this.y, 8, this.height);
        RenderUtil.resetShaderColor();
    }

    @Override
    public void renderBefore(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        WidgetUtil.renderText(this, guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public RGBA getCurrentBackgroundColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.sliderBackgroundColor;
    }

    public RGBA getCurrentSliderColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.sliderColor;
    }

    @Override
    public Component getCurrentText() {
        return this.getMessage();
    }

    @Override
    public RGBA getCurrentTextColor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.active ? this.textColor : this.disabledTextColor;
    }

    @Override
    public float getCurrentScale(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        return this.scale;
    }
}

