/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.registry.LazyEntry;
import info.u_team.u_team_core.api.registry.client.KeyMappingRegister;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;

public abstract class CommonKeyMappingRegister
implements KeyMappingRegister {
    protected final Map<KeyMappingLazyEntry, Supplier<KeyMapping>> entries = new LinkedHashMap<KeyMappingLazyEntry, Supplier<KeyMapping>>();

    protected CommonKeyMappingRegister() {
    }

    @Override
    public LazyEntry<KeyMapping> register(Supplier<KeyMapping> supplier) {
        KeyMappingLazyEntry entry = new KeyMappingLazyEntry();
        this.entries.put(entry, supplier);
        return entry;
    }

    protected void updateReference(KeyMappingLazyEntry entry, KeyMapping key) {
        entry.updateReference(key);
    }

    public static class KeyMappingLazyEntry
    implements LazyEntry<KeyMapping> {
        private KeyMapping value;

        KeyMappingLazyEntry() {
        }

        void updateReference(KeyMapping key) {
            this.value = key;
        }

        @Override
        public KeyMapping get() {
            Objects.requireNonNull(this.value, () -> "Key mapping not present");
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }
    }
}

