/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import info.u_team.u_team_core.api.fluid.FluidHandlerModifiable;
import info.u_team.u_team_core.api.menu.FluidContainerListener;
import info.u_team.u_team_core.intern.network.ContainerSetFluidContentMessage;
import info.u_team.u_team_core.intern.network.ContainerSetFluidSlotMessage;
import info.u_team.u_team_core.menu.FluidContainerMenu;
import info.u_team.u_team_core.menu.FluidSlot;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgeFluidContainerMenuDelegator
implements FluidContainerMenu.FluidContainerDelegator {
    private final FluidContainerMenu menu;
    private final NonNullList<FluidStack> lastFluidSlots = NonNullList.create();
    public final List<FluidSlot> fluidSlots = NonNullList.create();
    private final NonNullList<FluidStack> remoteFluidSlots = NonNullList.create();

    NeoForgeFluidContainerMenuDelegator(FluidContainerMenu menu) {
        this.menu = menu;
    }

    public FluidSlot addFluidSlot(FluidSlot slot) {
        slot.index = this.fluidSlots.size();
        this.fluidSlots.add(slot);
        this.lastFluidSlots.add((Object)FluidStack.EMPTY);
        this.remoteFluidSlots.add((Object)FluidStack.EMPTY);
        return slot;
    }

    public FluidSlot getFluidSlot(int slotId) {
        return this.fluidSlots.get(slotId);
    }

    public void fluidSlotClick(ServerPlayer player, int index, boolean shift, ItemStack clientClickStack) {
        int maximumTries;
        ItemStack serverClickStack = this.menu.getCarried();
        if (serverClickStack.isEmpty() || !ItemStack.matches((ItemStack)clientClickStack, (ItemStack)serverClickStack) || index < 0 && index >= this.fluidSlots.size()) {
            return;
        }
        FluidSlot fluidSlot = this.fluidSlots.get(index);
        Optional<FluidStack> containedFluidOptional = FluidUtil.getFluidHandler((ItemStack)serverClickStack.copyWithCount(1)).map(handler -> handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (!containedFluidOptional.isPresent()) {
            return;
        }
        int n = maximumTries = shift ? serverClickStack.getCount() : 1;
        if (!containedFluidOptional.orElseThrow(AssertionError::new).isEmpty()) {
            for (int i = 0; i < maximumTries && this.insertFluidFromItem(player, fluidSlot, shift); ++i) {
            }
        } else {
            for (int i = 0; i < maximumTries && this.extractFluidToItem(player, fluidSlot, shift); ++i) {
            }
        }
    }

    private boolean insertFluidFromItem(ServerPlayer player, FluidSlot fluidSlot, boolean shift) {
        int maxAmountToFill;
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.getInventory());
        ItemStack stack = this.menu.getCarried();
        Optional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)stack.copyWithCount(1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        FluidStack drainedFluidStack = handler.drain(maxAmountToFill = fluidSlot.getRemainingSlotCapacity(), IFluidHandler.FluidAction.EXECUTE);
        if (drainedFluidStack.isEmpty() || !fluidSlot.mayPlace(drainedFluidStack)) {
            return false;
        }
        boolean slotEmpty = fluidSlot.getFluid().isEmpty();
        if (!slotEmpty && !FluidStack.isSameFluidSameComponents((FluidStack)drainedFluidStack, (FluidStack)fluidSlot.getFluid())) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.getCount() == 1 && !shift) {
            if (slotEmpty) {
                fluidSlot.set(drainedFluidStack);
            } else {
                fluidSlot.getFluid().grow(drainedFluidStack.getAmount());
                fluidSlot.setChanged();
            }
            this.menu.setCarried(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).isEmpty()) {
            if (slotEmpty) {
                fluidSlot.set(drainedFluidStack);
            } else {
                fluidSlot.getFluid().grow(drainedFluidStack.getAmount());
                fluidSlot.setChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.shrink(1);
            if (stack.isEmpty()) {
                this.menu.setCarried(ItemStack.EMPTY);
            }
        }
        return true;
    }

    private boolean extractFluidToItem(ServerPlayer player, FluidSlot fluidSlot, boolean shift) {
        PlayerMainInvWrapper playerInventory = new PlayerMainInvWrapper(player.getInventory());
        ItemStack stack = this.menu.getCarried();
        Optional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)stack.copyWithCount(1));
        if (!fluidHandlerOptional.isPresent()) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)fluidHandlerOptional.orElseThrow(AssertionError::new);
        int amountFilled = handler.fill(fluidSlot.getFluid(), IFluidHandler.FluidAction.EXECUTE);
        if (amountFilled <= 0) {
            return false;
        }
        ItemStack outputStack = handler.getContainer();
        if (stack.getCount() == 1 && !shift) {
            fluidSlot.getFluid().shrink(amountFilled);
            if (fluidSlot.getFluid().isEmpty()) {
                fluidSlot.set(FluidStack.EMPTY);
            } else {
                fluidSlot.setChanged();
            }
            this.menu.setCarried(outputStack);
        } else if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)true).isEmpty()) {
            fluidSlot.getFluid().shrink(amountFilled);
            if (fluidSlot.getFluid().isEmpty()) {
                fluidSlot.set(FluidStack.EMPTY);
            } else {
                fluidSlot.setChanged();
            }
            ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)outputStack, (boolean)false);
            stack.shrink(1);
            if (stack.isEmpty()) {
                this.menu.setCarried(ItemStack.EMPTY);
            }
        }
        return true;
    }

    @Override
    public void sendAllDataToRemote() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            this.remoteFluidSlots.set(slot, (Object)this.fluidSlots.get(slot).getFluid().copy());
        }
        if (this.menu.getSynchronizerPlayer() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)this.menu.getSynchronizerPlayer(), (CustomPacketPayload)new ContainerSetFluidContentMessage(this.menu.containerId, this.menu.incrementStateId(), (List<FluidStack>)this.remoteFluidSlots), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void broadcastChanges() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getFluid();
            Supplier supplier = Suppliers.memoize(() -> ((FluidStack)stack).copy());
            this.triggerFluidSlotListeners(slot, stack, (java.util.function.Supplier<FluidStack>)supplier);
            this.synchronizeFluidSlotToRemote(slot, stack, (java.util.function.Supplier<FluidStack>)supplier);
        }
    }

    @Override
    public void broadcastFullState() {
        for (int slot = 0; slot < this.fluidSlots.size(); ++slot) {
            FluidStack stack = this.fluidSlots.get(slot).getFluid();
            this.triggerFluidSlotListeners(slot, stack, () -> ((FluidStack)stack).copy());
        }
    }

    private void triggerFluidSlotListeners(int slotId, FluidStack stack, java.util.function.Supplier<FluidStack> supplier) {
        FluidStack lastStack = (FluidStack)this.lastFluidSlots.get(slotId);
        if (!FluidStack.matches((FluidStack)lastStack, (FluidStack)stack)) {
            FluidStack copy = supplier.get();
            this.lastFluidSlots.set(slotId, (Object)copy);
            for (ContainerListener listener : this.menu.containerListeners) {
                if (!(listener instanceof FluidContainerListener)) continue;
                FluidContainerListener fluidListener = (FluidContainerListener)listener;
                fluidListener.fluidSlotChanged(this.menu, slotId, copy);
            }
        }
    }

    private void synchronizeFluidSlotToRemote(int slotId, FluidStack stack, java.util.function.Supplier<FluidStack> supplier) {
        FluidStack remoteStack;
        if (!this.menu.suppressRemoteUpdates && !FluidStack.matches((FluidStack)(remoteStack = (FluidStack)this.remoteFluidSlots.get(slotId)), (FluidStack)stack)) {
            FluidStack copy = supplier.get();
            this.remoteFluidSlots.set(slotId, (Object)copy);
            if (this.menu.getSynchronizerPlayer() != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)this.menu.getSynchronizerPlayer(), (CustomPacketPayload)new ContainerSetFluidSlotMessage(this.menu.containerId, this.menu.incrementStateId(), slotId, copy), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void setRemoteFluidSlot(int slotId, FluidStack stack) {
        this.remoteFluidSlots.set(slotId, (Object)stack.copy());
    }

    public void setRemoteFluidSlotNoCopy(int slotId, FluidStack stack) {
        this.remoteFluidSlots.set(slotId, (Object)stack);
    }

    public void setFluid(int slotId, int stateId, FluidStack stack) {
        this.getFluidSlot(slotId).set(stack);
        this.menu.stateId = stateId;
    }

    public void initializeFluidContents(int stateId, List<FluidStack> stacks) {
        for (int index = 0; index < stacks.size(); ++index) {
            this.getFluidSlot(index).set(stacks.get(index));
        }
        this.menu.stateId = stateId;
    }

    public List<FluidStack> getLastFluidSlots() {
        return this.lastFluidSlots;
    }

    public void addFluidSlots(FluidHandlerModifiable handler, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, 0, inventoryHeight, inventoryWidth, x, y);
    }

    public void addFluidSlots(FluidHandlerModifiable handler, FluidSlotHandlerFunction function, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, function, 0, inventoryHeight, inventoryWidth, x, y);
    }

    public void addFluidSlots(FluidHandlerModifiable handler, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        this.addFluidSlots(handler, FluidSlot::new, startIndex, inventoryHeight, inventoryWidth, x, y);
    }

    public void addFluidSlots(FluidHandlerModifiable handler, FluidSlotHandlerFunction function, int startIndex, int inventoryHeight, int inventoryWidth, int x, int y) {
        for (int height = 0; height < inventoryHeight; ++height) {
            for (int width = 0; width < inventoryWidth; ++width) {
                this.addFluidSlot(function.getSlot(handler, startIndex + (width + height * inventoryWidth), width * 18 + x, height * 18 + y));
            }
        }
    }

    @FunctionalInterface
    public static interface FluidSlotHandlerFunction {
        public FluidSlot getSlot(FluidHandlerModifiable var1, int var2, int var3, int var4);
    }

    public static class Factory
    implements FluidContainerMenu.FluidContainerDelegator.Factory {
        @Override
        public FluidContainerMenu.FluidContainerDelegator create(FluidContainerMenu menu) {
            return new NeoForgeFluidContainerMenuDelegator(menu);
        }
    }
}

